/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.schema.impl;

import com.introproventures.graphql.jpa.query.schema.impl.GraphQLJpaQueryFactory;
import com.introproventures.graphql.jpa.query.schema.impl.PageArgument;
import com.introproventures.graphql.jpa.query.schema.impl.ResultStreamWrapper;
import com.introproventures.graphql.jpa.query.support.GraphQLSupport;
import graphql.language.Argument;
import graphql.language.Field;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

class GraphQLJpaStreamDataFetcher
implements DataFetcher<Object> {
    private static final Logger logger = LoggerFactory.getLogger(GraphQLJpaStreamDataFetcher.class);
    private final GraphQLJpaQueryFactory queryFactory;

    private GraphQLJpaStreamDataFetcher(Builder builder) {
        this.queryFactory = builder.queryFactory;
    }

    public Object get(DataFetchingEnvironment environment) {
        Field field = environment.getField();
        Optional<Argument> pageArgument = GraphQLSupport.getPageArgument(field);
        PageArgument page = GraphQLSupport.extractPageArgument(environment, pageArgument, 100);
        field = GraphQLSupport.removeArgument(field, pageArgument);
        Stream<Object> resultStream = this.queryFactory.queryResultStream(environment, 100, Collections.emptyList());
        return Flux.fromIterable(ResultStreamWrapper.wrap(resultStream, page.getLimit()));
    }

    public static IQueryFactoryStage builder() {
        return new Builder();
    }

    public static final class Builder
    implements IQueryFactoryStage,
    IBuildStage {
        private GraphQLJpaQueryFactory queryFactory;

        private Builder() {
        }

        @Override
        public IBuildStage withQueryFactory(GraphQLJpaQueryFactory queryFactory) {
            this.queryFactory = queryFactory;
            return this;
        }

        @Override
        public GraphQLJpaStreamDataFetcher build() {
            return new GraphQLJpaStreamDataFetcher(this);
        }
    }

    public static interface IBuildStage {
        public GraphQLJpaStreamDataFetcher build();
    }

    public static interface IQueryFactoryStage {
        public IBuildStage withQueryFactory(GraphQLJpaQueryFactory var1);
    }
}

