/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.schema.impl;

import com.introproventures.graphql.jpa.query.schema.impl.GraphQLJpaQueryFactory;
import com.introproventures.graphql.jpa.query.schema.impl.GraphQLJpaToOneMappedBatchLoader;
import graphql.language.Argument;
import graphql.language.Field;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLNamedType;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.Optional;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderOptions;
import org.dataloader.DataLoaderRegistry;
import org.dataloader.MappedBatchLoaderWithContext;

class GraphQLJpaToOneDataFetcher
implements DataFetcher<Object> {
    private final SingularAttribute<Object, Object> attribute;
    private final GraphQLJpaQueryFactory queryFactory;

    public GraphQLJpaToOneDataFetcher(GraphQLJpaQueryFactory queryFactory, SingularAttribute<Object, Object> attribute) {
        this.queryFactory = queryFactory;
        this.attribute = attribute;
    }

    public Object get(DataFetchingEnvironment environment) {
        Field field = environment.getField();
        GraphQLNamedType parentType = (GraphQLNamedType)environment.getParentType();
        Object source = environment.getSource();
        Optional<Argument> whereArgument = this.queryFactory.getArgument(field, "where");
        Boolean isOptional = this.queryFactory.getOptionalArgumentValue(environment, field, (Attribute<?, ?>)this.attribute);
        if (whereArgument.isPresent() && isOptional.booleanValue() && !Attribute.PersistentAttributeType.EMBEDDED.equals((Object)this.attribute.getPersistentAttributeType())) {
            Object parentIdValue = this.queryFactory.getParentIdAttributeValue(source);
            String dataLoaderKey = parentType.getName() + "." + Optional.ofNullable(field.getAlias()).orElseGet(() -> this.attribute.getName());
            DataLoader<Object, Object> dataLoader = this.getDataLoader(environment, dataLoaderKey);
            return dataLoader.load(parentIdValue, (Object)environment);
        }
        return this.queryFactory.getAttributeValue(source, this.attribute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataLoader<Object, Object> getDataLoader(DataFetchingEnvironment environment, String dataLoaderKey) {
        DataLoaderRegistry dataLoaderRegistry = environment.getDataLoaderRegistry();
        if (!dataLoaderRegistry.getKeys().contains(dataLoaderKey)) {
            DataLoaderRegistry dataLoaderRegistry2 = dataLoaderRegistry;
            synchronized (dataLoaderRegistry2) {
                GraphQLJpaToOneMappedBatchLoader mappedBatchLoader = new GraphQLJpaToOneMappedBatchLoader(this.queryFactory);
                DataLoaderOptions options = DataLoaderOptions.newOptions().setCachingEnabled(false);
                DataLoader dataLoader = DataLoader.newMappedDataLoader((MappedBatchLoaderWithContext)mappedBatchLoader, (DataLoaderOptions)options);
                dataLoaderRegistry.register(dataLoaderKey, dataLoader);
            }
        }
        return environment.getDataLoader(dataLoaderKey);
    }
}

