/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.schema.impl;

import com.introproventures.graphql.jpa.query.schema.impl.PredicateFilter;
import graphql.language.NullValue;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.PluralAttribute;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

class JpaPredicateBuilder {
    public static final Map<Class<?>, Class<?>> WRAPPERS_TO_PRIMITIVES = new HashMap();
    public static final Map<Class<?>, Class<?>> PRIMITIVES_TO_WRAPPERS = new HashMap();
    public static final Set<Class<?>> JAVA_SCALARS = new LinkedHashSet();
    private final CriteriaBuilder cb;

    public JpaPredicateBuilder(CriteriaBuilder cb) {
        this.cb = cb;
    }

    protected Predicate addOrNull(Path<?> root, Predicate p) {
        Predicate pr = this.cb.isNull(root);
        return this.cb.or((Expression)p, (Expression)pr);
    }

    protected Predicate getStringPredicate(Path<String> root, PredicateFilter filter) {
        Predicate arrayValuePredicate = this.mayBeArrayValuePredicate((Path<?>)root, filter);
        if (arrayValuePredicate == null) {
            Object compareValue = filter.getValue().toString();
            Expression fieldValue = root;
            if (filter.anyMatch(PredicateFilter.Criteria.EQ_, PredicateFilter.Criteria.NE_, PredicateFilter.Criteria.LIKE_, PredicateFilter.Criteria.STARTS_, PredicateFilter.Criteria.ENDS_, PredicateFilter.Criteria.LOWER)) {
                compareValue = ((String)compareValue).toLowerCase();
                fieldValue = this.cb.lower(fieldValue);
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.IN)) {
                CriteriaBuilder.In in = this.cb.in(fieldValue);
                return in.value(compareValue);
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.NIN)) {
                return this.cb.not((Expression)fieldValue.in(new Object[]{compareValue}));
            }
            if (filter.anyMatch(PredicateFilter.Criteria.EQ, PredicateFilter.Criteria.LOWER, PredicateFilter.Criteria.EQ_)) {
                return this.cb.equal(fieldValue, compareValue);
            }
            if (filter.anyMatch(PredicateFilter.Criteria.NE, PredicateFilter.Criteria.NE_)) {
                return this.cb.notEqual(fieldValue, compareValue);
            }
            if (filter.anyMatch(PredicateFilter.Criteria.LIKE, PredicateFilter.Criteria.LIKE_)) {
                compareValue = "%" + (String)compareValue + "%";
            } else if (filter.anyMatch(PredicateFilter.Criteria.STARTS, PredicateFilter.Criteria.STARTS_)) {
                compareValue = (String)compareValue + "%";
            } else if (filter.anyMatch(PredicateFilter.Criteria.ENDS, PredicateFilter.Criteria.ENDS_)) {
                compareValue = "%" + (String)compareValue;
            } else if (!filter.anyMatch(PredicateFilter.Criteria.EXACT, PredicateFilter.Criteria.CASE)) {
                compareValue = "%";
            }
            return this.cb.like(fieldValue, (String)compareValue);
        }
        return arrayValuePredicate;
    }

    protected Predicate getBooleanPredicate(Path<?> root, PredicateFilter filter) {
        Boolean bool = (Boolean)filter.getValue();
        if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.NE)) {
            bool = bool == false;
        }
        return this.cb.equal(root, (Object)bool);
    }

    protected Predicate getIntegerPredicate(Path<? extends Number> root, PredicateFilter filter) {
        Predicate arrayValuePredicate = this.mayBeArrayValuePredicate(root, filter);
        if (arrayValuePredicate == null && filter.getValue() != null && filter.getValue() instanceof Number) {
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.IN)) {
                CriteriaBuilder.In in = this.cb.in(root);
                return in.value(filter.getValue());
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.NIN)) {
                return this.cb.not((Expression)root.in(new Object[]{filter.getValue()}));
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.LT)) {
                return this.cb.lt(root, (Number)filter.getValue());
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.GT)) {
                return this.cb.gt(root, (Number)filter.getValue());
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.LE)) {
                return this.cb.le(root, (Number)filter.getValue());
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.GE)) {
                return this.cb.ge(root, (Number)filter.getValue());
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.NE)) {
                return this.cb.notEqual(root, filter.getValue());
            }
            return this.cb.equal(root, filter.getValue());
        }
        return arrayValuePredicate;
    }

    protected Predicate mayBeArrayValuePredicate(Path<?> path, PredicateFilter filter) {
        if (filter.getValue().getClass().isArray()) {
            Object[] values;
            if (!filter.getCriterias().contains((Object)PredicateFilter.Criteria.NE) && !filter.getCriterias().contains((Object)PredicateFilter.Criteria.NIN)) {
                CriteriaBuilder.In in = this.cb.in(path);
                for (Object n : (Object[])filter.getValue()) {
                    in.value(n);
                }
                return in;
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.NE) || filter.getCriterias().contains((Object)PredicateFilter.Criteria.NIN)) {
                return this.cb.not((Expression)path.in((Object[])filter.getValue()));
            }
            if (!filter.getCriterias().contains((Object)PredicateFilter.Criteria.NE) && (filter.getCriterias().contains((Object)PredicateFilter.Criteria.BETWEEN) || filter.getCriterias().contains((Object)PredicateFilter.Criteria.NOT_BETWEEN)) && (values = (Object[])filter.getValue()).length == 2) {
                Path name = path.get(filter.getField());
                Predicate between = this.cb.between((Expression)name, this.cb.literal((Object)((String)values[0])), this.cb.literal((Object)((String)values[1])));
                if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.BETWEEN)) {
                    return between;
                }
                return this.cb.not((Expression)between);
            }
        } else if (filter.getValue() instanceof Collection) {
            if (!(filter.getCriterias().contains((Object)PredicateFilter.Criteria.NE) || filter.getCriterias().contains((Object)PredicateFilter.Criteria.NIN) || filter.getCriterias().contains((Object)PredicateFilter.Criteria.NOT_BETWEEN) || filter.getCriterias().contains((Object)PredicateFilter.Criteria.BETWEEN))) {
                CriteriaBuilder.In in = this.cb.in(path);
                for (Object n : (Collection)filter.getValue()) {
                    in.value(n);
                }
                return in;
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.NE) || filter.getCriterias().contains((Object)PredicateFilter.Criteria.NIN)) {
                return this.cb.not((Expression)path.in((Collection)filter.getValue()));
            }
            if (!filter.getCriterias().contains((Object)PredicateFilter.Criteria.NE) && (filter.getCriterias().contains((Object)PredicateFilter.Criteria.NOT_BETWEEN) || filter.getCriterias().contains((Object)PredicateFilter.Criteria.BETWEEN))) {
                Path<?> name = path;
                Collection collection = (Collection)filter.getValue();
                if (collection.size() == 2) {
                    Object[] values = collection.toArray();
                    Expression fromValue = this.cb.literal(values[0]);
                    Expression toValue = this.cb.literal(values[1]);
                    Predicate between = this.cb.between(name, fromValue, toValue);
                    if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.BETWEEN)) {
                        return between;
                    }
                    return this.cb.not((Expression)between);
                }
            }
        }
        return null;
    }

    protected Predicate getFloatingPointPredicate(Path<? extends Number> root, PredicateFilter filter) {
        Predicate arrayValuePredicate = this.mayBeArrayValuePredicate(root, filter);
        if (arrayValuePredicate == null && filter.getValue() != null && filter.getValue() instanceof Number) {
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.LT)) {
                return this.cb.lt(root, (Number)filter.getValue());
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.GT)) {
                return this.cb.gt(root, (Number)filter.getValue());
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.GE)) {
                return this.cb.ge(root, (Number)filter.getValue());
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.EQ)) {
                return this.cb.equal(root, filter.getValue());
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.NE)) {
                return this.cb.notEqual(root, filter.getValue());
            }
            return this.cb.le(root, (Number)filter.getValue());
        }
        return arrayValuePredicate;
    }

    protected Predicate getDatePredicate(Path<? extends java.util.Date> root, PredicateFilter filter) {
        Object[] values;
        if (filter.getValue() != null && filter.getValue() instanceof java.util.Date) {
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.LT)) {
                return this.cb.lessThan(root, (Comparable)((java.util.Date)filter.getValue()));
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.GT)) {
                return this.cb.greaterThan(root, (Comparable)((java.util.Date)filter.getValue()));
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.GE)) {
                return this.cb.greaterThanOrEqualTo(root, (Comparable)((java.util.Date)filter.getValue()));
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.EQ)) {
                return this.cb.equal(root, filter.getValue());
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.NE)) {
                return this.cb.notEqual(root, filter.getValue());
            }
            return this.cb.lessThanOrEqualTo(root, (Comparable)((java.util.Date)filter.getValue()));
        }
        if ((filter.getValue().getClass().isArray() || filter.getValue() instanceof Collection) && !filter.getCriterias().contains((Object)PredicateFilter.Criteria.NE) && (filter.getCriterias().contains((Object)PredicateFilter.Criteria.BETWEEN) || filter.getCriterias().contains((Object)PredicateFilter.Criteria.NOT_BETWEEN)) && (values = filter.getValue().getClass().isArray() ? (Object[])filter.getValue() : ((Collection)filter.getValue()).toArray()).length == 2) {
            Path<? extends java.util.Date> name = root;
            Expression fromDate = this.cb.literal((Object)((java.util.Date)values[0]));
            Expression toDate = this.cb.literal((Object)((java.util.Date)values[1]));
            Predicate between = this.cb.between(name, fromDate, toDate);
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.BETWEEN)) {
                return between;
            }
            return this.cb.not((Expression)between);
        }
        return null;
    }

    protected Predicate getLocalDatePredicate(Path<? extends LocalDate> root, PredicateFilter filter) {
        Object[] values;
        if (filter.getValue() != null && filter.getValue() instanceof LocalDate) {
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.LT)) {
                return this.cb.lessThan(root, (Comparable)((LocalDate)filter.getValue()));
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.GT)) {
                return this.cb.greaterThan(root, (Comparable)((LocalDate)filter.getValue()));
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.GE)) {
                return this.cb.greaterThanOrEqualTo(root, (Comparable)((LocalDate)filter.getValue()));
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.EQ)) {
                return this.cb.equal(root, filter.getValue());
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.NE)) {
                return this.cb.notEqual(root, filter.getValue());
            }
            return this.cb.lessThanOrEqualTo(root, (Comparable)((LocalDate)filter.getValue()));
        }
        if ((filter.getValue().getClass().isArray() || filter.getValue() instanceof Collection) && !filter.getCriterias().contains((Object)PredicateFilter.Criteria.NE) && (filter.getCriterias().contains((Object)PredicateFilter.Criteria.BETWEEN) || filter.getCriterias().contains((Object)PredicateFilter.Criteria.NOT_BETWEEN)) && (values = filter.getValue().getClass().isArray() ? (Object[])filter.getValue() : ((Collection)filter.getValue()).toArray()).length == 2) {
            Path<? extends LocalDate> name = root;
            Expression fromDate = this.cb.literal((Object)((LocalDate)values[0]));
            Expression toDate = this.cb.literal((Object)((LocalDate)values[1]));
            Predicate between = this.cb.between(name, fromDate, toDate);
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.BETWEEN)) {
                return between;
            }
            return this.cb.not((Expression)between);
        }
        return null;
    }

    protected Predicate getLocalDateTimePredicate(Path<? extends LocalDateTime> root, PredicateFilter filter) {
        Object[] values;
        if (filter.getValue() != null && filter.getValue() instanceof LocalDateTime) {
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.LT)) {
                return this.cb.lessThan(root, (Comparable)((LocalDateTime)filter.getValue()));
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.GT)) {
                return this.cb.greaterThan(root, (Comparable)((LocalDateTime)filter.getValue()));
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.GE)) {
                return this.cb.greaterThanOrEqualTo(root, (Comparable)((LocalDateTime)filter.getValue()));
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.EQ)) {
                return this.cb.equal(root, filter.getValue());
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.NE)) {
                return this.cb.notEqual(root, filter.getValue());
            }
            return this.cb.lessThanOrEqualTo(root, (Comparable)((LocalDateTime)filter.getValue()));
        }
        if ((filter.getValue().getClass().isArray() || filter.getValue() instanceof Collection) && !filter.getCriterias().contains((Object)PredicateFilter.Criteria.NE) && (filter.getCriterias().contains((Object)PredicateFilter.Criteria.BETWEEN) || filter.getCriterias().contains((Object)PredicateFilter.Criteria.NOT_BETWEEN)) && (values = filter.getValue().getClass().isArray() ? (Object[])filter.getValue() : ((Collection)filter.getValue()).toArray()).length == 2) {
            Path<? extends LocalDateTime> name = root;
            Expression fromDateTime = this.cb.literal((Object)((LocalDateTime)values[0]));
            Expression toDateTime = this.cb.literal((Object)((LocalDateTime)values[1]));
            Predicate between = this.cb.between(name, fromDateTime, toDateTime);
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.BETWEEN)) {
                return between;
            }
            return this.cb.not((Expression)between);
        }
        return null;
    }

    protected Predicate getInstantPredicate(Path<? extends Instant> root, PredicateFilter filter) {
        Object[] values;
        if (filter.getValue() != null && filter.getValue() instanceof Instant) {
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.LT)) {
                return this.cb.lessThan(root, (Comparable)((Instant)filter.getValue()));
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.GT)) {
                return this.cb.greaterThan(root, (Comparable)((Instant)filter.getValue()));
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.GE)) {
                return this.cb.greaterThanOrEqualTo(root, (Comparable)((Instant)filter.getValue()));
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.EQ)) {
                return this.cb.equal(root, filter.getValue());
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.NE)) {
                return this.cb.notEqual(root, filter.getValue());
            }
            return this.cb.lessThanOrEqualTo(root, (Comparable)((Instant)filter.getValue()));
        }
        if ((filter.getValue().getClass().isArray() || filter.getValue() instanceof Collection) && !filter.getCriterias().contains((Object)PredicateFilter.Criteria.NE) && (filter.getCriterias().contains((Object)PredicateFilter.Criteria.BETWEEN) || filter.getCriterias().contains((Object)PredicateFilter.Criteria.NOT_BETWEEN)) && (values = filter.getValue().getClass().isArray() ? (Object[])filter.getValue() : ((Collection)filter.getValue()).toArray()).length == 2) {
            Path<? extends Instant> name = root;
            Expression fromDate = this.cb.literal((Object)((Instant)values[0]));
            Expression toDate = this.cb.literal((Object)((Instant)values[1]));
            Predicate between = this.cb.between(name, fromDate, toDate);
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.BETWEEN)) {
                return between;
            }
            return this.cb.not((Expression)between);
        }
        return null;
    }

    protected Predicate getLocalTimePredicate(Path<? extends LocalTime> root, PredicateFilter filter) {
        Object[] values;
        if (filter.getValue() != null && filter.getValue() instanceof LocalTime) {
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.LT)) {
                return this.cb.lessThan(root, (Comparable)((LocalTime)filter.getValue()));
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.GT)) {
                return this.cb.greaterThan(root, (Comparable)((LocalTime)filter.getValue()));
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.GE)) {
                return this.cb.greaterThanOrEqualTo(root, (Comparable)((LocalTime)filter.getValue()));
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.EQ)) {
                return this.cb.equal(root, filter.getValue());
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.NE)) {
                return this.cb.notEqual(root, filter.getValue());
            }
            return this.cb.lessThanOrEqualTo(root, (Comparable)((LocalTime)filter.getValue()));
        }
        if ((filter.getValue().getClass().isArray() || filter.getValue() instanceof Collection) && !filter.getCriterias().contains((Object)PredicateFilter.Criteria.NE) && (filter.getCriterias().contains((Object)PredicateFilter.Criteria.BETWEEN) || filter.getCriterias().contains((Object)PredicateFilter.Criteria.NOT_BETWEEN)) && (values = filter.getValue().getClass().isArray() ? (Object[])filter.getValue() : ((Collection)filter.getValue()).toArray()).length == 2) {
            Path<? extends LocalTime> name = root;
            Expression fromTime = this.cb.literal((Object)((LocalTime)values[0]));
            Expression toTime = this.cb.literal((Object)((LocalTime)values[1]));
            Predicate between = this.cb.between(name, fromTime, toTime);
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.BETWEEN)) {
                return between;
            }
            return this.cb.not((Expression)between);
        }
        return null;
    }

    protected Predicate getZonedDateTimePredicate(Path<? extends ZonedDateTime> root, PredicateFilter filter) {
        Object[] values;
        if (filter.getValue() != null && filter.getValue() instanceof ZonedDateTime) {
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.LT)) {
                return this.cb.lessThan(root, (Comparable)((ZonedDateTime)filter.getValue()));
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.GT)) {
                return this.cb.greaterThan(root, (Comparable)((ZonedDateTime)filter.getValue()));
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.GE)) {
                return this.cb.greaterThanOrEqualTo(root, (Comparable)((ZonedDateTime)filter.getValue()));
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.EQ)) {
                return this.cb.equal(root, filter.getValue());
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.NE)) {
                return this.cb.notEqual(root, filter.getValue());
            }
            return this.cb.lessThanOrEqualTo(root, (Comparable)((ZonedDateTime)filter.getValue()));
        }
        if ((filter.getValue().getClass().isArray() || filter.getValue() instanceof Collection) && !filter.getCriterias().contains((Object)PredicateFilter.Criteria.NE) && (filter.getCriterias().contains((Object)PredicateFilter.Criteria.BETWEEN) || filter.getCriterias().contains((Object)PredicateFilter.Criteria.NOT_BETWEEN)) && (values = filter.getValue().getClass().isArray() ? (Object[])filter.getValue() : ((Collection)filter.getValue()).toArray()).length == 2) {
            Path<? extends ZonedDateTime> name = root;
            Expression fromDateTime = this.cb.literal((Object)((ZonedDateTime)values[0]));
            Expression toDateTime = this.cb.literal((Object)((ZonedDateTime)values[1]));
            Predicate between = this.cb.between(name, fromDateTime, toDateTime);
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.BETWEEN)) {
                return between;
            }
            return this.cb.not((Expression)between);
        }
        return null;
    }

    protected Predicate getOffsetDateTimePredicate(Path<? extends OffsetDateTime> root, PredicateFilter filter) {
        Object[] values;
        if (filter.getValue() != null && filter.getValue() instanceof OffsetDateTime) {
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.LT)) {
                return this.cb.lessThan(root, (Comparable)((OffsetDateTime)filter.getValue()));
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.GT)) {
                return this.cb.greaterThan(root, (Comparable)((OffsetDateTime)filter.getValue()));
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.GE)) {
                return this.cb.greaterThanOrEqualTo(root, (Comparable)((OffsetDateTime)filter.getValue()));
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.EQ)) {
                return this.cb.equal(root, filter.getValue());
            }
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.NE)) {
                return this.cb.notEqual(root, filter.getValue());
            }
            return this.cb.lessThanOrEqualTo(root, (Comparable)((OffsetDateTime)filter.getValue()));
        }
        if ((filter.getValue().getClass().isArray() || filter.getValue() instanceof Collection) && !filter.getCriterias().contains((Object)PredicateFilter.Criteria.NE) && (filter.getCriterias().contains((Object)PredicateFilter.Criteria.BETWEEN) || filter.getCriterias().contains((Object)PredicateFilter.Criteria.NOT_BETWEEN)) && (values = filter.getValue().getClass().isArray() ? (Object[])filter.getValue() : ((Collection)filter.getValue()).toArray()).length == 2) {
            Path<? extends OffsetDateTime> name = root;
            Expression fromDateTime = this.cb.literal((Object)((OffsetDateTime)values[0]));
            Expression toDateTime = this.cb.literal((Object)((OffsetDateTime)values[1]));
            Predicate between = this.cb.between(name, fromDateTime, toDateTime);
            if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.BETWEEN)) {
                return between;
            }
            return this.cb.not((Expression)between);
        }
        return null;
    }

    private Predicate getUuidPredicate(Path<UUID> field, PredicateFilter filter) {
        if (filter.getValue() == null) {
            return null;
        }
        Predicate arrayPredicate = this.mayBeArrayValuePredicate(field, filter);
        if (arrayPredicate != null) {
            return arrayPredicate;
        }
        UUID compareValue = (UUID)filter.getValue();
        if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.EQ)) {
            return this.cb.equal(field, (Object)compareValue);
        }
        if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.IN)) {
            CriteriaBuilder.In in = this.cb.in(field);
            return in.value((Object)compareValue);
        }
        if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.NE)) {
            return this.cb.notEqual(field, (Object)compareValue);
        }
        return null;
    }

    private Predicate getEnumPredicate(Path<? extends Enum> field, PredicateFilter filter) {
        if (filter.getValue() == null) {
            return null;
        }
        Predicate arrayPredicate = this.mayBeArrayValuePredicate(field, filter);
        if (arrayPredicate != null) {
            return arrayPredicate;
        }
        Enum compareValue = (Enum)filter.getValue();
        if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.EQ)) {
            return this.cb.equal(field, (Object)compareValue);
        }
        if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.IN)) {
            CriteriaBuilder.In in = this.cb.in(field);
            return in.value((Object)compareValue);
        }
        if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.NIN)) {
            CriteriaBuilder.In in = this.cb.in(field);
            return this.cb.not((Expression)in.value((Object)compareValue));
        }
        if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.NE)) {
            return this.cb.notEqual(field, (Object)compareValue);
        }
        return null;
    }

    private Predicate getTypedPredicate(From<?, ?> from, Path<?> field, PredicateFilter filter) {
        Class<?> type = filter.getJavaType();
        Object value = filter.getValue();
        Set<PredicateFilter.Criteria> criterias = filter.getCriterias();
        Attribute attribute = filter.getAttribute();
        if (value == null) {
            return this.cb.disjunction();
        }
        if (criterias.contains((Object)PredicateFilter.Criteria.IS_NULL)) {
            return (Boolean)value != false ? this.cb.isNull(field) : this.cb.isNotNull(field);
        }
        if (criterias.contains((Object)PredicateFilter.Criteria.NOT_NULL)) {
            return (Boolean)value != false ? this.cb.isNotNull(field) : this.cb.isNull(field);
        }
        if (type.isPrimitive()) {
            type = PRIMITIVES_TO_WRAPPERS.get(type);
        }
        if (NullValue.class.isInstance(value) && JAVA_SCALARS.contains(type)) {
            if (criterias.contains((Object)PredicateFilter.Criteria.EQ)) {
                return this.cb.isNull(field);
            }
            if (criterias.contains((Object)PredicateFilter.Criteria.NE)) {
                return this.cb.isNotNull(field);
            }
        }
        if (type.equals(String.class)) {
            return this.getStringPredicate(field, filter);
        }
        if (type.equals(Long.class) || type.equals(BigInteger.class) || type.equals(Integer.class) || type.equals(Short.class) || type.equals(Byte.class)) {
            return this.getIntegerPredicate(field, filter);
        }
        if (type.equals(BigDecimal.class) || type.equals(Double.class) || type.equals(Float.class)) {
            return this.getFloatingPointPredicate(field, filter);
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return this.getDatePredicate(field, filter);
        }
        if (type.equals(LocalDate.class)) {
            return this.getLocalDatePredicate(field, filter);
        }
        if (type.equals(LocalDateTime.class)) {
            return this.getLocalDateTimePredicate(field, filter);
        }
        if (type.equals(Instant.class)) {
            return this.getInstantPredicate(field, filter);
        }
        if (type.equals(LocalTime.class)) {
            return this.getLocalTimePredicate(field, filter);
        }
        if (type.equals(ZonedDateTime.class)) {
            return this.getZonedDateTimePredicate(field, filter);
        }
        if (type.equals(OffsetDateTime.class)) {
            return this.getOffsetDateTimePredicate(field, filter);
        }
        if (type.equals(Boolean.class)) {
            return this.getBooleanPredicate(field, filter);
        }
        if (type.equals(UUID.class)) {
            return this.getUuidPredicate(field, filter);
        }
        if (Collection.class.isAssignableFrom(type)) {
            if (PluralAttribute.class.isInstance(attribute) || EntityType.class.isInstance(attribute)) {
                Predicate predicate;
                Path expression = from.get(filter.getField());
                if (Collection.class.isInstance(filter.getValue())) {
                    ArrayList restrictions = new ArrayList();
                    ((Collection)Collection.class.cast(filter.getValue())).forEach(arg_0 -> this.lambda$getTypedPredicate$0(restrictions, (Expression)expression, arg_0));
                    predicate = this.cb.and(restrictions.toArray(new Predicate[0]));
                } else {
                    predicate = this.cb.isMember(filter.getValue(), (Expression)expression);
                }
                if (filter.anyMatch(PredicateFilter.Criteria.NIN, PredicateFilter.Criteria.NE)) {
                    return this.cb.not((Expression)predicate);
                }
                return predicate;
            }
        } else {
            if (type.isEnum()) {
                return this.getEnumPredicate(field, filter);
            }
            if (Object.class.isAssignableFrom(type)) {
                if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.LOCATE)) {
                    return this.cb.gt(this.cb.locate((Expression)from.get(filter.getField()), value.toString()), (Number)0);
                }
                Object object = value;
                object = Collection.class.isInstance(value) ? this.getValues(object, type) : this.getValue(object, type);
                if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.EQ) || filter.getCriterias().contains((Object)PredicateFilter.Criteria.NE)) {
                    Predicate equal = this.cb.equal((Expression)from.get(filter.getField()), object);
                    if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.NE)) {
                        return this.cb.not((Expression)equal);
                    }
                    return equal;
                }
                if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.IN) || filter.getCriterias().contains((Object)PredicateFilter.Criteria.NIN)) {
                    CriteriaBuilder.In in = this.cb.in((Expression)from.get(filter.getField()));
                    if (Collection.class.isInstance(object)) {
                        ((Collection)Collection.class.cast(object)).forEach(arg_0 -> ((CriteriaBuilder.In)in).value(arg_0));
                    } else {
                        in.value(object);
                    }
                    if (filter.getCriterias().contains((Object)PredicateFilter.Criteria.NIN)) {
                        return this.cb.not((Expression)in);
                    }
                    return in;
                }
            }
        }
        throw new IllegalArgumentException("Unsupported field type " + String.valueOf(type) + " for field " + filter.getField());
    }

    private Object getValue(Object object, Class<?> type) {
        try {
            Constructor<?> constructor = type.getConstructor(Object.class);
            if (constructor != null) {
                Object arg = NullValue.class.isInstance(object) ? null : object;
                return constructor.newInstance(arg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    private Object getValues(Object object, Class<?> type) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (Object value : ((Collection)Collection.class.cast(object)).toArray()) {
            objects.add(this.getValue(value, type));
        }
        return objects;
    }

    public Predicate getPredicate(From<?, ?> from, Path<?> field, PredicateFilter filter) {
        return this.getTypedPredicate(from, field, filter);
    }

    private /* synthetic */ void lambda$getTypedPredicate$0(List restrictions, Expression expression, Object v) {
        restrictions.add(this.cb.isMember(v, expression));
    }

    static {
        PRIMITIVES_TO_WRAPPERS.put(Boolean.TYPE, Boolean.class);
        PRIMITIVES_TO_WRAPPERS.put(Byte.TYPE, Byte.class);
        PRIMITIVES_TO_WRAPPERS.put(Character.TYPE, Character.class);
        PRIMITIVES_TO_WRAPPERS.put(Double.TYPE, Double.class);
        PRIMITIVES_TO_WRAPPERS.put(Float.TYPE, Float.class);
        PRIMITIVES_TO_WRAPPERS.put(Integer.TYPE, Integer.class);
        PRIMITIVES_TO_WRAPPERS.put(Long.TYPE, Long.class);
        PRIMITIVES_TO_WRAPPERS.put(Short.TYPE, Short.class);
        PRIMITIVES_TO_WRAPPERS.put(Void.TYPE, Void.class);
        WRAPPERS_TO_PRIMITIVES.put(Boolean.class, Boolean.TYPE);
        WRAPPERS_TO_PRIMITIVES.put(Byte.class, Byte.TYPE);
        WRAPPERS_TO_PRIMITIVES.put(Character.class, Character.TYPE);
        WRAPPERS_TO_PRIMITIVES.put(Double.class, Double.TYPE);
        WRAPPERS_TO_PRIMITIVES.put(Float.class, Float.TYPE);
        WRAPPERS_TO_PRIMITIVES.put(Integer.class, Integer.TYPE);
        WRAPPERS_TO_PRIMITIVES.put(Long.class, Long.TYPE);
        WRAPPERS_TO_PRIMITIVES.put(Short.class, Short.TYPE);
        WRAPPERS_TO_PRIMITIVES.put(Void.class, Void.TYPE);
        JAVA_SCALARS.addAll(Arrays.asList(Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Short.class, BigInteger.class, BigDecimal.class, String.class, java.util.Date.class, LocalDate.class, LocalDateTime.class, ZonedDateTime.class, Instant.class, LocalTime.class, Calendar.class, OffsetDateTime.class, Date.class, Time.class, Timestamp.class, UUID.class));
    }
}

