/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.schema.impl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PagedResult<T> {
    private final long limit;
    private final long total;
    private final long pages;
    private final int offset;
    private final List<T> select;
    private final Map<String, Object> aggregate;

    private PagedResult(Builder<T> builder) {
        this.limit = builder.limit;
        this.total = builder.total;
        this.offset = builder.offset;
        this.select = builder.select;
        this.pages = Double.valueOf(Math.ceil((double)this.total / (double)this.limit)).longValue();
        this.aggregate = builder.aggregate;
    }

    public Long getTotal() {
        return this.total;
    }

    public Long getPages() {
        return this.pages;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public List<T> getSelect() {
        return this.select;
    }

    public long getLimit() {
        return this.limit;
    }

    public Map<String, Object> getAggregate() {
        return this.aggregate;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static final class Builder<T> {
        private long limit;
        private long total;
        private long pages;
        private int offset;
        private List<T> select = Collections.emptyList();
        private Map<String, Object> aggregate = new LinkedHashMap<String, Object>();

        private Builder() {
        }

        public Builder<T> withLimit(long limit) {
            this.limit = limit;
            return this;
        }

        public Builder<T> withTotal(long total) {
            this.total = total;
            return this;
        }

        public Builder<T> withPages(long pages) {
            this.pages = pages;
            return this;
        }

        public Builder<T> withOffset(int offset) {
            this.offset = offset;
            return this;
        }

        public Builder<T> withSelect(List<T> select) {
            this.select = select;
            return this;
        }

        public Builder<T> withAggregate(Map<String, Object> aggregate) {
            this.aggregate.putAll(aggregate);
            return this;
        }

        public PagedResult<T> build() {
            return new PagedResult(this);
        }
    }
}

