/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.schema.impl;

import jakarta.persistence.metamodel.Attribute;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class PredicateFilter
implements Comparable<PredicateFilter>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String field;
    private final Object typedValue;
    private final EnumSet<Criteria> criterias;
    private final Attribute attribute;

    public PredicateFilter(String field, Object value, Set<Criteria> criterias, Attribute attribute) {
        this.field = field;
        this.typedValue = value;
        this.criterias = EnumSet.copyOf(criterias);
        this.attribute = attribute;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public Class<?> getJavaType() {
        return this.attribute.getJavaType();
    }

    public String getField() {
        return this.field;
    }

    public Object getValue() {
        return this.typedValue;
    }

    public Set<Criteria> getCriterias() {
        return EnumSet.copyOf(this.criterias);
    }

    @Override
    public int compareTo(PredicateFilter o) {
        return this.getField().compareTo(o.getField());
    }

    public boolean anyMatch(Criteria ... criterias) {
        return Stream.of(criterias).anyMatch((? super T criteria) -> this.getCriterias().contains(criteria));
    }

    public static enum Criteria {
        LT,
        GT,
        LE,
        GE,
        EQ,
        NE,
        NE_,
        CASE,
        LOWER,
        EQ_,
        ENDS,
        ENDS_,
        STARTS,
        STARTS_,
        LIKE,
        LIKE_,
        EXACT,
        IS_NULL,
        NOT_NULL,
        IN,
        NIN,
        BETWEEN,
        NOT_BETWEEN,
        LOCATE;

        private static Set<String> names;

        public static Set<String> names() {
            return names;
        }

        static {
            names = EnumSet.allOf(Criteria.class).stream().map(it -> it.name().toString()).collect(Collectors.toSet());
        }
    }
}

