/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.schema.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;

class ResultStreamWrapper<T> {
    ResultStreamWrapper() {
    }

    public static <T> List<T> wrap(Stream<T> stream, int size) {
        return (List)Proxy.newProxyInstance(ResultStreamWrapper.class.getClassLoader(), new Class[]{List.class}, new ListProxyInvocationHandler<T>(stream, size));
    }

    public static <T> List<T> wrap(Collection<T> collection, int size) {
        return ResultStreamWrapper.wrap(collection.stream(), size);
    }

    static class ListProxyInvocationHandler<T>
    implements InvocationHandler {
        private final Stream<T> stream;
        private final int size;

        public ListProxyInvocationHandler(Stream<T> stream, int size) {
            this.stream = stream;
            this.size = size;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("size".equals(method.getName())) {
                return this.size;
            }
            if ("iterator".equals(method.getName())) {
                return this.stream.limit(this.size).iterator();
            }
            if ("equals".equals(method.getName())) {
                return proxy == args[0];
            }
            if ("hashCode".equals(method.getName())) {
                return System.identityHashCode(proxy);
            }
            if ("spliterator".equals(method.getName())) {
                return this.stream.spliterator();
            }
            throw new UnsupportedOperationException(String.valueOf(method) + " is not supported");
        }
    }
}

