/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.schema.relay;

import com.introproventures.graphql.jpa.query.schema.impl.GraphQLJpaQueryFactory;
import com.introproventures.graphql.jpa.query.schema.impl.PagedResult;
import com.introproventures.graphql.jpa.query.schema.relay.OffsetBasedCursor;
import com.introproventures.graphql.jpa.query.schema.relay.Page;
import com.introproventures.graphql.jpa.query.schema.relay.PageFactory;
import com.introproventures.graphql.jpa.query.support.GraphQLSupport;
import graphql.language.Field;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLJpaRelayDataFetcher
implements DataFetcher<Page<Object>> {
    private static final Logger logger = LoggerFactory.getLogger(GraphQLJpaRelayDataFetcher.class);
    private static final String EDGES = "edges";
    private static final String FIRST = "first";
    private static final String AFTER = "after";
    private static final String PAGE_INFO = "pageInfo";
    private final int defaultMaxResults;
    private final int defaultFirstSize;
    private final boolean enableDefaultMaxResults;
    private final GraphQLJpaQueryFactory queryFactory;

    private GraphQLJpaRelayDataFetcher(Builder builder) {
        this.queryFactory = builder.queryFactory;
        this.defaultMaxResults = builder.defaultMaxResults;
        this.defaultFirstSize = builder.defaultFirstSize;
        this.enableDefaultMaxResults = builder.enableDefaultMaxResults;
    }

    public Page<Object> get(DataFetchingEnvironment environment) throws Exception {
        Field rootNode = environment.getField();
        Optional<Field> edgesSelection = GraphQLSupport.searchByFieldName(rootNode, EDGES);
        Optional<Field> pageInfoSelection = GraphQLSupport.getSelectionField(rootNode, PAGE_INFO);
        Optional<Integer> firstArgument = Optional.ofNullable((Integer)environment.getArgument(FIRST));
        Optional<String> afterArgument = Optional.ofNullable((String)environment.getArgument(AFTER));
        Integer first = firstArgument.orElse(this.defaultFirstSize);
        String after = afterArgument.orElse(new OffsetBasedCursor(0L).toConnectionCursor().toString());
        OffsetBasedCursor cursor = OffsetBasedCursor.fromCursor(after);
        int firstResult = Integer.parseInt(Long.toString(cursor.getOffset()));
        int maxResults = Integer.min(first, this.defaultMaxResults);
        PagedResult.Builder<Object> pagedResult = PagedResult.builder().withOffset(firstResult).withLimit(maxResults);
        Optional<List<Object>> restrictedKeys = this.queryFactory.getRestrictedKeys(environment);
        if (edgesSelection.isPresent() && restrictedKeys.isPresent()) {
            ArrayList<Object> queryKeys = new ArrayList<Object>();
            if (this.enableDefaultMaxResults || firstArgument.isPresent() || afterArgument.isPresent()) {
                queryKeys.addAll(this.queryFactory.queryKeys(environment, firstResult, maxResults, restrictedKeys.get()));
            } else {
                queryKeys.addAll((Collection)restrictedKeys.get());
            }
            List<Object> resultList = this.queryFactory.queryResultList(environment, maxResults, queryKeys);
            pagedResult.withSelect(resultList);
        }
        if (pageInfoSelection.isPresent()) {
            Long total = this.queryFactory.queryTotalCount(environment, restrictedKeys);
            pagedResult.withTotal(total);
        }
        PagedResult result = pagedResult.build();
        return PageFactory.createOffsetBasedPage(result.getSelect(), result.getTotal(), result.getOffset().intValue());
    }

    public static IQueryFactoryStage builder() {
        return new Builder();
    }

    public static final class Builder
    implements IQueryFactoryStage,
    IDefaultMaxResultsStage,
    IDefaultFirstSizeStage,
    IBuildStage {
        private GraphQLJpaQueryFactory queryFactory;
        private int defaultMaxResults;
        private int defaultFirstSize;
        private boolean enableDefaultMaxResults;

        private Builder() {
        }

        @Override
        public IDefaultMaxResultsStage withQueryFactory(GraphQLJpaQueryFactory queryFactory) {
            this.queryFactory = queryFactory;
            return this;
        }

        @Override
        public IDefaultMaxResultsStage withDefaultMaxResults(int defaultMaxResults) {
            this.defaultMaxResults = defaultMaxResults;
            return this;
        }

        @Override
        public IBuildStage withDefaultFirstSize(int defaultFirstSize) {
            this.defaultFirstSize = defaultFirstSize;
            return this;
        }

        @Override
        public GraphQLJpaRelayDataFetcher build() {
            return new GraphQLJpaRelayDataFetcher(this);
        }

        @Override
        public IDefaultFirstSizeStage withEnableDefaultMaxResults(boolean enableDefaultMaxResults) {
            this.enableDefaultMaxResults = enableDefaultMaxResults;
            return this;
        }
    }

    public static interface IBuildStage {
        public GraphQLJpaRelayDataFetcher build();
    }

    public static interface IDefaultFirstSizeStage {
        public IBuildStage withDefaultFirstSize(int var1);
    }

    public static interface IDefaultMaxResultsStage {
        public IDefaultMaxResultsStage withDefaultMaxResults(int var1);

        public IDefaultFirstSizeStage withEnableDefaultMaxResults(boolean var1);
    }

    public static interface IQueryFactoryStage {
        public IDefaultMaxResultsStage withQueryFactory(GraphQLJpaQueryFactory var1);
    }
}

