/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.autumn.client;

import com.google.common.base.Optional;
import java.util.Map;

public class HttpCallConfig<T> {
    private String httpMethod;
    private String url;
    private Object data;
    private Class<T> toMap;
    private Map<String, String> headers;
    private Map<String, String> queryParams;
    private String accept;
    private String type;
    private int expectedStatus;
    private Integer connectionTimeout;
    private Integer readTimeOut;
    private String proxyURL;
    private int proxyPort;
    private boolean useConnectionPooling;
    private Integer maxConnectionPerHost;

    public boolean getUseConnectionPooling() {
        return this.useConnectionPooling;
    }

    public void setUseConnectionPooling(boolean useConnectionPooling) {
        this.useConnectionPooling = useConnectionPooling;
    }

    public Optional<Integer> getMaxConnectionPerHost() {
        return Optional.fromNullable((Object)this.maxConnectionPerHost);
    }

    public void setMaxConnectionPerHost(Integer maxConnectionPerHost) {
        this.maxConnectionPerHost = maxConnectionPerHost;
    }

    public Optional<String> getProxyURL() {
        return Optional.fromNullable((Object)this.proxyURL);
    }

    public void setProxyURL(String proxyURL) {
        this.proxyURL = proxyURL;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public Optional<Integer> getConnectionTimeout() {
        return Optional.fromNullable((Object)this.connectionTimeout);
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Optional<Integer> getReadTimeOut() {
        return Optional.fromNullable((Object)this.readTimeOut);
    }

    public void setReadTimeOut(Integer readTimeOut) {
        this.readTimeOut = readTimeOut;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Optional<Object> getData() {
        return Optional.fromNullable((Object)this.data);
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Class<T> getToMap() {
        return this.toMap;
    }

    public void setToMap(Class<T> toMap) {
        this.toMap = toMap;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public void setQueryParams(Map<String, String> queryParams) {
        this.queryParams = queryParams;
    }

    public String getAccept() {
        return this.accept;
    }

    public void setAccept(String accept) {
        this.accept = accept;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getExpectedStatus() {
        return this.expectedStatus;
    }

    public void setExpectedStatus(int expectedStatus) {
        this.expectedStatus = expectedStatus;
    }

    public static class Builder<T> {
        private String httpMethod;
        private String url;
        private Object data;
        private Class<T> toMap;
        private Map<String, String> headers;
        private Map<String, String> queryParams;
        private String accept;
        private String type;
        private int expectedStatus;
        private Integer connectionTimeout;
        private Integer readTimeOut;
        private String proxyURL;
        private int proxyPort;
        private boolean useConnectionPooling;
        private Integer maxConnectionPerHost;

        private Builder() {
        }

        public static Builder aHttpCallConfig() {
            return new Builder();
        }

        public Builder withHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder withData(Object data) {
            this.data = data;
            return this;
        }

        public Builder withToMap(Class<T> toMap) {
            this.toMap = toMap;
            return this;
        }

        public Builder withHeaders(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder withQueryParams(Map<String, String> queryParams) {
            this.queryParams = queryParams;
            return this;
        }

        public Builder withAccept(String accept) {
            this.accept = accept;
            return this;
        }

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Builder withExpectedStatus(int expectedStatus) {
            this.expectedStatus = expectedStatus;
            return this;
        }

        public Builder withConnectionTimeout(Integer connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder withReadTimeOut(Integer readTimeOut) {
            this.readTimeOut = readTimeOut;
            return this;
        }

        public Builder withProxyURL(String proxyURL) {
            this.proxyURL = proxyURL;
            return this;
        }

        public Builder withProxyPort(int proxyPort) {
            this.proxyPort = proxyPort;
            return this;
        }

        public Builder withUseConnectionPooling(boolean useConnectionPooling) {
            this.useConnectionPooling = useConnectionPooling;
            return this;
        }

        public Builder withMaxConnectionPerHost(Integer maxConnectionPerHost) {
            this.maxConnectionPerHost = maxConnectionPerHost;
            return this;
        }

        public Builder but() {
            return Builder.aHttpCallConfig().withHttpMethod(this.httpMethod).withUrl(this.url).withData(this.data).withToMap(this.toMap).withHeaders(this.headers).withQueryParams(this.queryParams).withAccept(this.accept).withType(this.type).withExpectedStatus(this.expectedStatus).withConnectionTimeout(this.connectionTimeout).withReadTimeOut(this.readTimeOut).withProxyURL(this.proxyURL).withProxyPort(this.proxyPort).withUseConnectionPooling(this.useConnectionPooling).withMaxConnectionPerHost(this.maxConnectionPerHost);
        }

        public HttpCallConfig build() {
            HttpCallConfig<T> httpCallConfig = new HttpCallConfig<T>();
            httpCallConfig.setHttpMethod(this.httpMethod);
            httpCallConfig.setUrl(this.url);
            httpCallConfig.setData(this.data);
            httpCallConfig.setToMap(this.toMap);
            httpCallConfig.setHeaders(this.headers);
            httpCallConfig.setQueryParams(this.queryParams);
            httpCallConfig.setAccept(this.accept);
            httpCallConfig.setType(this.type);
            httpCallConfig.setExpectedStatus(this.expectedStatus);
            httpCallConfig.setConnectionTimeout(this.connectionTimeout);
            httpCallConfig.setReadTimeOut(this.readTimeOut);
            httpCallConfig.setProxyURL(this.proxyURL);
            httpCallConfig.setProxyPort(this.proxyPort);
            httpCallConfig.setUseConnectionPooling(this.useConnectionPooling);
            httpCallConfig.setMaxConnectionPerHost(this.maxConnectionPerHost);
            return httpCallConfig;
        }
    }
}

