/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.autumn.client.impl;

import com.google.inject.Inject;
import com.intuit.autumn.client.HttpCall;
import com.intuit.autumn.client.HttpCallConfig;
import com.intuit.autumn.client.impl.HttpCallException;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCallImpl<T>
implements HttpCall<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpCall.class);

    @Inject
    public HttpCallImpl() {
    }

    @Override
    public T makeRequest(String httpMethod, String url, Object data, Class<T> toMap, Map<String, String> headers, Map<String, String> queryParams, String accept, String type, int expectedStatus) {
        return this.makeRequest(httpMethod, HttpCallConfig.Builder.aHttpCallConfig().withUrl(url).withData(data).withToMap(toMap).withHeaders(headers).withQueryParams(queryParams).withAccept(accept).withType(type).withExpectedStatus(expectedStatus).build());
    }

    @Override
    public T makeRequest(String httpMethod, HttpCallConfig<T> config) {
        ClientResponse response = this.getResponse(httpMethod, config);
        if (response != null && response.getStatus() != config.getExpectedStatus()) {
            String msg = String.format("error, get call to %s returned status was %s expecting status = %s", config.getUrl(), response.getStatus(), config.getExpectedStatus());
            LOGGER.error(msg);
            response.close();
            throw new HttpCallException(msg);
        }
        if (response == null) {
            String msg = String.format("error, get call to %s expecting status = %s", config.getUrl(), config.getExpectedStatus());
            LOGGER.error(msg);
            throw new UnsupportedOperationException(msg);
        }
        return (T)(config.getToMap() == null || ClientResponse.class == config.getToMap() ? response : response.getEntity(config.getToMap()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ClientResponse getResponse(String httpMethod, HttpCallConfig<T> config) {
        Client client = this.getClient(config);
        WebResource webResource = client.resource(config.getUrl());
        webResource = this.addQueryParams(webResource, config.getQueryParams());
        WebResource.Builder builder = this.addHeaders(webResource, config.getHeaders(), config.getAccept(), config.getType());
        ClientResponse response = null;
        try {
            switch (httpMethod) {
                case "GET": {
                    response = (ClientResponse)builder.get(ClientResponse.class);
                    return response;
                }
                case "POST": {
                    response = config.getData().isPresent() ? (ClientResponse)builder.post(ClientResponse.class, config.getData().get()) : (ClientResponse)builder.post(ClientResponse.class);
                    return response;
                }
                case "PUT": {
                    response = config.getData().isPresent() ? (ClientResponse)builder.put(ClientResponse.class, config.getData().get()) : (ClientResponse)builder.put(ClientResponse.class);
                    return response;
                }
                case "DELETE": {
                    response = (ClientResponse)builder.delete(ClientResponse.class);
                    return response;
                }
                default: {
                    String msg = String.format("error, unsupported HTTP method called %s", httpMethod);
                    LOGGER.error(msg);
                    throw new UnsupportedOperationException(msg);
                }
            }
        }
        finally {
            client.destroy();
        }
    }

    private Client getClient(final HttpCallConfig<T> config) {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        Client client = new Client((ClientHandler)new URLConnectionClientHandler(new HttpURLConnectionFactory(){
            Proxy p = null;

            public HttpURLConnection getHttpURLConnection(URL url) throws IOException {
                if (this.p == null) {
                    this.p = config.getProxyURL().isPresent() ? new Proxy(Proxy.Type.HTTP, new InetSocketAddress((String)config.getProxyURL().get(), config.getProxyPort())) : Proxy.NO_PROXY;
                }
                return (HttpURLConnection)url.openConnection(this.p);
            }
        }), (ClientConfig)clientConfig);
        if ((Integer)config.getConnectionTimeout().or((Object)-1) > 0) {
            client.setConnectTimeout((Integer)config.getConnectionTimeout().get());
        }
        if ((Integer)config.getReadTimeOut().or((Object)-1) > 0) {
            client.setReadTimeout((Integer)config.getReadTimeOut().get());
        }
        client.getProperties().put("com.sun.jersey.client.property.bufferResponseEntityOnException", true);
        LOGGER.info("Properties of the sun jersey client used by the application: {}", (Object)client.getProperties().toString());
        return client;
    }

    @Override
    public WebResource.Builder addHeaders(WebResource webResource, Map<String, String> headers, String accept, String type) {
        WebResource.Builder builder = webResource.getRequestBuilder();
        if (accept != null) {
            builder.accept(new String[]{accept});
        }
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                builder.header(entry.getKey(), (Object)entry.getValue());
            }
        }
        if (type != null) {
            builder.type(type);
        }
        return builder;
    }

    @Override
    public WebResource addQueryParams(WebResource webResource, Map<String, String> queryParams) {
        WebResource resource = webResource;
        if (queryParams != null) {
            for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                resource = resource.queryParam(entry.getKey(), entry.getValue());
            }
        }
        return resource;
    }

    @Override
    public T doGet(String url, Class<T> toMap, Map<String, String> headers, Map<String, String> queryParams, String accept, int expectedStatus) {
        return this.makeRequest("GET", url, null, toMap, headers, queryParams, accept, null, expectedStatus);
    }

    @Override
    public T doPost(String url, Object data, Class<T> toMap, Map<String, String> headers, Map<String, String> queryParams, String accept, String type, int expectedStatus) {
        return this.makeRequest("POST", url, data, toMap, headers, queryParams, accept, type, expectedStatus);
    }

    @Override
    public T doPost(HttpCallConfig<T> httpCallConfig) {
        return this.makeRequest("POST", httpCallConfig);
    }

    @Override
    public T doGet(HttpCallConfig<T> httpCallConfig) {
        return this.makeRequest("GET", httpCallConfig);
    }

    @Override
    public T doPut(HttpCallConfig<T> httpCallConfig) {
        return this.makeRequest("PUT", httpCallConfig);
    }

    @Override
    public T doDelete(HttpCallConfig<T> httpCallConfig) {
        return this.makeRequest("DELETE", httpCallConfig);
    }

    @Override
    public T doPut(String url, Object data, Class<T> toMap, Map<String, String> headers, Map<String, String> queryParams, String accept, String type, int expectedStatus) {
        return this.makeRequest("PUT", url, data, toMap, headers, queryParams, accept, type, expectedStatus);
    }

    @Override
    public T doDelete(String url, Class<T> toMap, Map<String, String> headers, Map<String, String> queryParams, String accept, int expectedStatus) {
        return this.makeRequest("DELETE", url, null, toMap, headers, queryParams, accept, null, expectedStatus);
    }
}

