/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.autumn.client.impl;

import com.google.inject.Inject;
import com.intuit.autumn.client.HttpCall;
import com.intuit.autumn.client.HttpCallConfig;
import com.intuit.autumn.client.impl.HttpCallException;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.client.apache.ApacheHttpClient;
import com.sun.jersey.client.apache.ApacheHttpClientHandler;
import com.sun.jersey.client.apache.config.DefaultApacheHttpClientConfig;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCallImplWithConnectionPooling<T>
implements HttpCall<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpCall.class);
    private Client client;

    @Inject
    public HttpCallImplWithConnectionPooling() {
    }

    @Override
    public T makeRequest(String httpMethod, String url, Object data, Class<T> toMap, Map<String, String> headers, Map<String, String> queryParams, String accept, String type, int expectedStatus) {
        return this.makeRequest(httpMethod, HttpCallConfig.Builder.aHttpCallConfig().withUrl(url).withData(data).withToMap(toMap).withHeaders(headers).withQueryParams(queryParams).withAccept(accept).withType(type).withExpectedStatus(expectedStatus).build());
    }

    @Override
    public T makeRequest(String httpMethod, HttpCallConfig<T> config) {
        ClientResponse response = this.getResponse(httpMethod, config);
        if (response == null) {
            String msg = String.format("data.autumn: HttpCalls: error for the request with following parameters: %s", config.toString());
            LOGGER.error(msg);
            throw new UnsupportedOperationException(msg);
        }
        if (response.getStatus() != config.getExpectedStatus()) {
            String msg = String.format("data.autumn: HttpCalls: error, get call to %s returned status was %s expecting status = %s", config.getUrl(), response.getStatus(), config.getExpectedStatus());
            LOGGER.error(msg);
            response.close();
            throw new HttpCallException(msg);
        }
        return (T)(ClientResponse.class == config.getToMap() || config.getToMap() == null ? response : response.getEntity(config.getToMap()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ClientResponse getResponse(String httpMethod, HttpCallConfig<T> config) {
        this.client = this.getClient(config);
        WebResource webResource = this.client.resource(config.getUrl());
        webResource = this.addQueryParams(webResource, config.getQueryParams());
        WebResource.Builder builder = this.addHeaders(webResource, config.getHeaders(), config.getAccept(), config.getType());
        ClientResponse response = null;
        try {
            switch (httpMethod) {
                case "GET": {
                    response = (ClientResponse)builder.get(ClientResponse.class);
                    return response;
                }
                case "POST": {
                    response = config.getData().isPresent() ? (ClientResponse)builder.post(ClientResponse.class, config.getData().get()) : (ClientResponse)builder.post(ClientResponse.class);
                    return response;
                }
                case "PUT": {
                    response = config.getData().isPresent() ? (ClientResponse)builder.put(ClientResponse.class, config.getData().get()) : (ClientResponse)builder.put(ClientResponse.class);
                    return response;
                }
                case "DELETE": {
                    response = (ClientResponse)builder.delete(ClientResponse.class);
                    return response;
                }
                default: {
                    String msg = String.format("data.autumn: HttpCalls: error, unsupported HTTP method called %s", httpMethod);
                    LOGGER.error(msg);
                    throw new UnsupportedOperationException(msg);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("data.autumn: HttpCall error", (Throwable)e);
            return response;
        }
        finally {
            if (!config.getUseConnectionPooling()) {
                this.client.destroy();
            }
        }
    }

    private Client getClient(HttpCallConfig<T> config) {
        if (!config.getUseConnectionPooling() || this.client == null) {
            MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
            if ((Integer)config.getMaxConnectionPerHost().or((Object)-1) > 0) {
                connectionManager.getParams().setDefaultMaxConnectionsPerHost(((Integer)config.getMaxConnectionPerHost().get()).intValue());
            } else {
                connectionManager.getParams().setDefaultMaxConnectionsPerHost(20);
            }
            HttpClient httpClient = new HttpClient((HttpConnectionManager)connectionManager);
            ApacheHttpClientHandler clientHandler = new ApacheHttpClientHandler(httpClient);
            ApacheHttpClient root = new ApacheHttpClient(clientHandler);
            DefaultApacheHttpClientConfig config1 = new DefaultApacheHttpClientConfig();
            if (config.getProxyURL().isPresent()) {
                String proxyURLWithPort = "http://" + config.getProxyURL() + ':' + config.getProxyPort();
                config1.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyURI", proxyURLWithPort);
            }
            this.client = new Client((ClientHandler)root, (ClientConfig)config1);
            if ((Integer)config.getConnectionTimeout().or((Object)-1) > 0) {
                this.client.setConnectTimeout((Integer)config.getConnectionTimeout().get());
            }
            if ((Integer)config.getReadTimeOut().or((Object)-1) > 0) {
                this.client.setReadTimeout((Integer)config.getReadTimeOut().get());
            }
            LOGGER.info("Created a new client with the following properties set by the application {}", (Object)this.client.getProperties().toString());
        }
        return this.client;
    }

    @Override
    public WebResource.Builder addHeaders(WebResource webResource, Map<String, String> headers, String accept, String type) {
        WebResource.Builder builder = webResource.getRequestBuilder();
        if (accept != null) {
            builder.accept(new String[]{accept});
        }
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                builder.header(entry.getKey(), (Object)entry.getValue());
            }
        }
        if (type != null) {
            builder.type(type);
        }
        return builder;
    }

    @Override
    public WebResource addQueryParams(WebResource webResource, Map<String, String> queryParams) {
        WebResource resource = webResource;
        if (queryParams != null) {
            for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                resource = resource.queryParam(entry.getKey(), entry.getValue());
            }
        }
        return resource;
    }

    @Override
    public T doGet(String url, Class<T> toMap, Map<String, String> headers, Map<String, String> queryParams, String accept, int expectedStatus) {
        return this.makeRequest("GET", url, null, toMap, headers, queryParams, accept, null, expectedStatus);
    }

    @Override
    public T doPost(String url, Object data, Class<T> toMap, Map<String, String> headers, Map<String, String> queryParams, String accept, String type, int expectedStatus) {
        return this.makeRequest("POST", url, data, toMap, headers, queryParams, accept, type, expectedStatus);
    }

    @Override
    public T doPost(HttpCallConfig<T> httpCallConfig) {
        return this.makeRequest("POST", httpCallConfig);
    }

    @Override
    public T doGet(HttpCallConfig<T> httpCallConfig) {
        return this.makeRequest("GET", httpCallConfig);
    }

    @Override
    public T doPut(HttpCallConfig<T> httpCallConfig) {
        return this.makeRequest("PUT", httpCallConfig);
    }

    @Override
    public T doDelete(HttpCallConfig<T> httpCallConfig) {
        return this.makeRequest("DELETE", httpCallConfig);
    }

    @Override
    public T doPut(String url, Object data, Class<T> toMap, Map<String, String> headers, Map<String, String> queryParams, String accept, String type, int expectedStatus) {
        return this.makeRequest("PUT", url, data, toMap, headers, queryParams, accept, type, expectedStatus);
    }

    @Override
    public T doDelete(String url, Class<T> toMap, Map<String, String> headers, Map<String, String> queryParams, String accept, int expectedStatus) {
        return this.makeRequest("DELETE", url, null, toMap, headers, queryParams, accept, null, expectedStatus);
    }
}

