/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.autumn.manage;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.Hashtable;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBeanRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(MBeanRegistry.class);
    private final MBeanServer server;

    @Inject
    public MBeanRegistry(MBeanServer server) {
        this.server = server;
    }

    public void register(Object o, String name) {
        String packageName = o.getClass().getPackage().getName();
        ImmutableMap attributes = new ImmutableMap.Builder().put((Object)"name", (Object)name).put((Object)"type", (Object)o.getClass().getSimpleName()).build();
        try {
            ObjectName objectName = new ObjectName(packageName, new Hashtable<String, String>((Map<String, String>)attributes));
            this.server.registerMBean(o, objectName);
        }
        catch (MalformedObjectNameException e) {
            LOGGER.warn(String.format("invalid object name: %s, cause: %s", name, e.getMessage()), (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            LOGGER.warn(String.format("non-compliant mxbean: %s, cause: %s", name, e.getMessage()), (Throwable)e);
        }
        catch (InstanceAlreadyExistsException e) {
            LOGGER.warn(String.format("mxbean already exists by name: %s, cause: %s", name, e.getMessage()), (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            LOGGER.warn(String.format("unable to register mxbean name: %s, cause: %s", name, e.getMessage()), (Throwable)e);
        }
    }
}

