/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.autumn.manage;

import com.google.inject.AbstractModule;
import com.google.inject.Scopes;
import com.intuit.autumn.manage.MBeanRegistry;
import com.intuit.autumn.manage.ManageException;
import java.lang.management.ManagementFactory;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import javax.management.MBeanServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageModule
extends AbstractModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManageModule.class);

    protected void configure() {
        this.bind(MBeanServer.class).toInstance((Object)ManagementFactory.getPlatformMBeanServer());
        this.bind(MBeanRegistry.class).in(Scopes.SINGLETON);
    }

    static {
        String portStr = System.getProperty("com.sun.management.jmxremote.port");
        int port = portStr != null ? Integer.parseInt(portStr) + 1 : 18099;
        try {
            LocateRegistry.createRegistry(port);
        }
        catch (RemoteException e) {
            LOGGER.warn("unable to create registry on port: {}, cause: {}", (Object)port, (Object)e.getMessage());
            throw new ManageException(e);
        }
    }
}

