/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.autumn.metrics;

import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.intuit.autumn.metrics.MetricsException;
import java.io.File;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvMetricsService
extends AbstractIdleService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CsvMetricsService.class);
    private final File directory;
    private final int interval;
    private final MetricRegistry metricRegistry;
    private CsvReporter reporter;

    @Inject
    public CsvMetricsService(@Named(value="metrics.csv.directory") File directory, @Named(value="metrics.csv.interval.seconds") int interval, MetricRegistry metricRegistry) {
        LOGGER.debug("instantiating {}, directory: {}, interval: {}", new Object[]{this.serviceName(), directory, interval});
        this.directory = directory;
        this.interval = interval;
        this.metricRegistry = metricRegistry;
        LOGGER.debug("instantiated {}, directory: {}, interval: {}", new Object[]{this.serviceName(), directory, interval});
    }

    protected void startUp() throws Exception {
        if (this.reporter != null) {
            LOGGER.info("already started {}, directory: {}, interval: {}", new Object[]{this.serviceName(), this.directory, this.interval});
            return;
        }
        LOGGER.info("starting {}, directory: {}, interval: {}", new Object[]{this.serviceName(), this.directory, this.interval});
        if (this.directory.exists()) {
            FileUtils.moveDirectory((File)this.directory, (File)new File(this.directory.getAbsolutePath() + "." + System.currentTimeMillis()));
        }
        if (!this.directory.mkdirs()) {
            LOGGER.error("Can't create directory: {}", (Object)this.directory);
            throw new MetricsException(String.format("unable to make directory: %s", this.directory));
        }
        this.reporter = CsvReporter.forRegistry((MetricRegistry)this.metricRegistry).formatFor(Locale.US).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build(this.directory);
        this.reporter.start((long)this.interval, TimeUnit.SECONDS);
        LOGGER.info("started {}, directory: {}, interval: {}", new Object[]{this.serviceName(), this.directory, this.interval});
    }

    protected void shutDown() throws Exception {
        if (this.reporter == null) {
            LOGGER.info("already stopped {}", (Object)this.serviceName());
            return;
        }
        LOGGER.info("stopping {}", (Object)this.serviceName());
        this.reporter.stop();
        this.reporter = null;
        LOGGER.info("stopped {}", (Object)this.serviceName());
    }
}

