/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.autumn.metrics;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.graphite.GraphiteSender;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphiteMetricsService
extends AbstractIdleService {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphiteMetricsService.class);
    private final URI service;
    private final String prefix;
    private final int interval;
    private final MetricRegistry metricRegistry;
    private GraphiteReporter reporter;

    @Inject
    public GraphiteMetricsService(@Named(value="metrics.graphite.service") URI service, @Named(value="metrics.graphite.service.prefix") String prefix, @Named(value="metrics.graphite.interval.seconds") int interval, MetricRegistry metricRegistry) {
        LOGGER.debug("instantiating {}, service: {}, prefix: {}, interval: {}", new Object[]{this.serviceName(), service, prefix, interval});
        this.service = service;
        this.prefix = prefix;
        this.interval = interval;
        this.metricRegistry = metricRegistry;
        LOGGER.debug("instantiated {}, service: {}, prefix: {}, interval: {}", new Object[]{this.serviceName(), service, prefix, interval});
    }

    protected void startUp() throws Exception {
        if (this.reporter != null) {
            LOGGER.info("already started {}, service: {}, prefix: {}, interval: {}", new Object[]{this.serviceName(), this.service, this.prefix, this.interval});
            return;
        }
        LOGGER.info("starting {}, service: {}, prefix: {}, interval: {}", new Object[]{this.serviceName(), this.service, this.prefix, this.interval});
        Graphite graphite = new Graphite(this.service.getHost(), this.service.getPort());
        this.reporter = GraphiteReporter.forRegistry((MetricRegistry)this.metricRegistry).prefixedWith(this.prefix).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).build((GraphiteSender)graphite);
        this.reporter.start((long)this.interval, TimeUnit.SECONDS);
        LOGGER.info("started {}, service: {}, prefix: {}, interval: {}", new Object[]{this.serviceName(), this.service, this.prefix, this.interval});
    }

    protected void shutDown() throws Exception {
        if (this.reporter == null) {
            LOGGER.info("already stopped {}, service: {}, prefix: {}, interval: {}", new Object[]{this.serviceName(), this.service, this.prefix, this.interval});
            return;
        }
        LOGGER.info("stopping {}, service: {}, prefix: {}, interval: {}", new Object[]{this.serviceName(), this.service, this.prefix, this.interval});
        this.reporter.stop();
        this.reporter = null;
        LOGGER.info("stopped {}, service: {}, prefix: {}, interval: {}", new Object[]{this.serviceName(), this.service, this.prefix, this.interval});
    }
}

