/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.autumn.metrics;

import com.codahale.metrics.MetricRegistry;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.inject.Inject;
import com.netflix.hystrix.contrib.codahalemetricspublisher.HystrixCodaHaleMetricsPublisher;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HystrixMetricsService
extends AbstractIdleService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HystrixMetricsService.class);
    private final MetricRegistry metricRegistry;
    private HystrixCodaHaleMetricsPublisher hystrixCodaHaleMetricsPublisher;

    @Inject
    public HystrixMetricsService(MetricRegistry metricRegistry) {
        LOGGER.debug("instantiating {}", (Object)this.serviceName());
        this.metricRegistry = metricRegistry;
        LOGGER.debug("instantiated {}", (Object)this.serviceName());
    }

    protected void startUp() throws Exception {
        if (this.hystrixCodaHaleMetricsPublisher != null) {
            LOGGER.info("already started {}", (Object)this.serviceName());
            return;
        }
        LOGGER.info("starting {}", (Object)this.serviceName());
        this.hystrixCodaHaleMetricsPublisher = new HystrixCodaHaleMetricsPublisher(this.metricRegistry);
        HystrixPlugins.getInstance().registerMetricsPublisher((HystrixMetricsPublisher)this.hystrixCodaHaleMetricsPublisher);
        LOGGER.info("started {}", (Object)this.serviceName());
    }

    protected void shutDown() throws Exception {
        if (this.hystrixCodaHaleMetricsPublisher == null) {
            LOGGER.info("already stopped {}", (Object)this.serviceName());
            return;
        }
        LOGGER.info("stopping {}", (Object)this.serviceName());
        this.hystrixCodaHaleMetricsPublisher = null;
        LOGGER.info("stopped {}", (Object)this.serviceName());
    }
}

