/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.autumn.metrics;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxMetricsService
extends AbstractIdleService {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxMetricsService.class);
    private final MetricRegistry metricRegistry;
    private JmxReporter reporter;

    @Inject
    public JmxMetricsService(MetricRegistry metricRegistry) {
        LOGGER.debug("instantiating {}", (Object)this.serviceName());
        this.metricRegistry = metricRegistry;
        LOGGER.debug("instantiated {}", (Object)this.serviceName());
    }

    protected void startUp() throws Exception {
        if (this.reporter != null) {
            LOGGER.info("already started {}", (Object)this.serviceName());
            return;
        }
        LOGGER.info("starting {}", (Object)this.serviceName());
        this.reporter = JmxReporter.forRegistry((MetricRegistry)this.metricRegistry).build();
        this.reporter.start();
        LOGGER.info("started {}", (Object)this.serviceName());
    }

    protected void shutDown() throws Exception {
        if (this.reporter == null) {
            LOGGER.info("already stopped {}", (Object)this.serviceName());
            return;
        }
        LOGGER.info("stopping {}", (Object)this.serviceName());
        this.reporter.stop();
        this.reporter = null;
        LOGGER.info("stopped {}", (Object)this.serviceName());
    }
}

