/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.autumn.metrics;

import com.codahale.metrics.MetricRegistry;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.name.Names;
import com.intuit.autumn.manage.ManageModule;
import com.intuit.autumn.metrics.CsvMetricsService;
import com.intuit.autumn.metrics.GraphiteMetricsService;
import com.intuit.autumn.metrics.HystrixMetricsService;
import com.intuit.autumn.metrics.JmxMetricsService;
import com.intuit.autumn.utils.PropertyFactory;
import java.io.File;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsModule
extends AbstractModule {
    public static final String PROPERTY_NAME = "/metrics.properties";
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsModule.class);

    protected void configure() {
        this.install((Module)new ManageModule());
        LOGGER.debug("binding properties: {}", (Object)PROPERTY_NAME);
        Properties properties = PropertyFactory.create((String)PROPERTY_NAME, MetricsModule.class);
        this.bind(Boolean.class).annotatedWith((Annotation)Names.named((String)"metrics.csv.enabled")).toInstance((Object)Boolean.valueOf(PropertyFactory.getProperty((String)"metrics.csv.enabled", (Properties)properties)));
        this.bind(File.class).annotatedWith((Annotation)Names.named((String)"metrics.csv.directory")).toInstance((Object)new File(PropertyFactory.getProperty((String)"metrics.csv.directory", (Properties)properties)));
        this.bind(Integer.class).annotatedWith((Annotation)Names.named((String)"metrics.csv.interval.seconds")).toInstance((Object)Integer.valueOf(PropertyFactory.getProperty((String)"metrics.csv.interval.seconds", (Properties)properties)));
        this.bind(Boolean.class).annotatedWith((Annotation)Names.named((String)"metrics.graphite.enabled")).toInstance((Object)Boolean.valueOf(PropertyFactory.getProperty((String)"metrics.graphite.enabled", (Properties)properties)));
        this.bind(URI.class).annotatedWith((Annotation)Names.named((String)"metrics.graphite.service")).toInstance((Object)URI.create(PropertyFactory.getProperty((String)"metrics.graphite.service", (Properties)properties)));
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"metrics.graphite.service.prefix")).toInstance((Object)PropertyFactory.getProperty((String)"metrics.graphite.service.prefix", (Properties)properties));
        this.bind(Integer.class).annotatedWith((Annotation)Names.named((String)"metrics.graphite.interval.seconds")).toInstance((Object)Integer.valueOf(PropertyFactory.getProperty((String)"metrics.graphite.interval.seconds", (Properties)properties)));
        this.bind(Boolean.class).annotatedWith((Annotation)Names.named((String)"metrics.hystrix.enabled")).toInstance((Object)Boolean.valueOf(PropertyFactory.getProperty((String)"metrics.hystrix.enabled", (Properties)properties)));
        this.bind(Boolean.class).annotatedWith((Annotation)Names.named((String)"metrics.jmx.enabled")).toInstance((Object)Boolean.valueOf(PropertyFactory.getProperty((String)"metrics.jmx.enabled", (Properties)properties)));
        this.bind(MetricRegistry.class).in(Scopes.SINGLETON);
        this.bind(CsvMetricsService.class).in(Scopes.SINGLETON);
        this.bind(GraphiteMetricsService.class).in(Scopes.SINGLETON);
        this.bind(HystrixMetricsService.class).in(Scopes.SINGLETON);
        this.bind(JmxMetricsService.class).in(Scopes.SINGLETON);
        LOGGER.debug("bound properties: {}", (Object)PROPERTY_NAME);
    }
}

