/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.autumn.metrics;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Service;
import com.intuit.autumn.metrics.CsvMetricsService;
import com.intuit.autumn.metrics.GraphiteMetricsService;
import com.intuit.autumn.metrics.HystrixMetricsService;
import com.intuit.autumn.metrics.JmxMetricsService;
import com.intuit.autumn.metrics.MetricsModule;
import com.intuit.autumn.utils.PropertyFactory;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsServices {
    public static final String PROPERTY_NAME = "/metrics.properties";
    private static final String METRICS_GRAPHITE_ENABLED_KEY = "metrics.graphite.enabled";
    private static final ImmutableMap<String, Class<? extends Service>> METRICS_SERVICES = new ImmutableMap.Builder().put((Object)"metrics.csv.enabled", CsvMetricsService.class).put((Object)"metrics.graphite.enabled", GraphiteMetricsService.class).put((Object)"metrics.hystrix.enabled", HystrixMetricsService.class).put((Object)"metrics.jmx.enabled", JmxMetricsService.class).build();
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsServices.class);

    private MetricsServices() {
        throw new UnsupportedOperationException();
    }

    public static Set<Class<? extends Service>> getEnabledMetricsServices() {
        LOGGER.debug("getting enabled metrics services");
        Properties properties = PropertyFactory.create((String)PROPERTY_NAME, MetricsModule.class);
        HashSet metricsServices = Sets.newHashSet();
        MetricsServices.addIfEnabled(properties, metricsServices, "metrics.csv.enabled");
        MetricsServices.addIfEnabled(properties, metricsServices, METRICS_GRAPHITE_ENABLED_KEY);
        MetricsServices.addIfEnabled(properties, metricsServices, "metrics.hystrix.enabled", METRICS_GRAPHITE_ENABLED_KEY);
        MetricsServices.addIfEnabled(properties, metricsServices, "metrics.jmx.enabled");
        LOGGER.debug("got enabled metrics services count: {}", (Object)metricsServices.size());
        return metricsServices;
    }

    private static void addIfEnabled(Properties properties, Set<Class<? extends Service>> services, String ... keys) {
        int keyCounter = 0;
        boolean isEnabled = false;
        for (String key : keys) {
            if (++keyCounter == 1) {
                isEnabled = BooleanUtils.toBoolean((String)PropertyFactory.getProperty((String)key, (Properties)properties));
            }
            if (!isEnabled) continue;
            services.add((Class<? extends Service>)METRICS_SERVICES.get((Object)key));
        }
    }
}

