/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.autumn.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSource;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyFactory.class);

    private PropertyFactory() {
        throw new UnsupportedOperationException();
    }

    public static Properties create(String propertyResourceName) {
        return PropertyFactory.create(propertyResourceName, null);
    }

    public static Properties create(String propertyResourceName, @Nullable Class base) {
        LOGGER.debug("creating property: {}", (Object)propertyResourceName);
        Properties properties = new Properties();
        if (propertyResourceName != null) {
            LOGGER.debug("reading property: {}", (Object)propertyResourceName);
            try (InputStream is = PropertyFactory.class.getResourceAsStream(propertyResourceName);){
                LOGGER.debug("loading property: {}", (Object)propertyResourceName);
                properties.load(is);
            }
            catch (IOException e) {
                String msg = "unable to start service: " + propertyResourceName + " properties, cause: " + e.getMessage();
                LOGGER.warn(msg, (Throwable)e);
            }
            PropertyFactory.fromJar(propertyResourceName, base, properties);
        }
        return properties;
    }

    private static void fromJar(String propertyResourceName, @Nullable Class base, Properties properties) {
        if (base == null) {
            return;
        }
        CodeSource src = base.getProtectionDomain().getCodeSource();
        if (src == null) {
            return;
        }
        Properties propertiesFromJar = PropertyFactory.getPropertyFromJar(base, propertyResourceName.substring(1), src);
        for (Map.Entry<Object, Object> entry : propertiesFromJar.entrySet()) {
            if (properties.containsKey(entry.getKey())) continue;
            LOGGER.debug("overriding key: {}, newValue: {}, originalValue: {}", new Object[]{entry.getKey(), propertiesFromJar, entry.getValue()});
            properties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private static Properties getPropertyFromJar(Class base, String property, CodeSource src) {
        Properties properties = new Properties();
        URL jar = src.getLocation();
        return jar != null ? PropertyFactory.readZip(base, jar, property, properties) : properties;
    }

    private static Properties readZip(Class base, URL jar, String property, Properties properties) {
        try (ZipInputStream zip = new ZipInputStream(jar.openStream());){
            ZipEntry ze = zip.getNextEntry();
            while (ze != null) {
                if (ze.getName().equals(property)) {
                    properties.load(zip);
                    break;
                }
                ze = zip.getNextEntry();
            }
        }
        catch (IOException e) {
            LOGGER.warn("unable to read jar: {}, property: {}, class: {}, cause: {}", (Object)new Object[]{jar, property, base.getSimpleName(), e.getMessage()}, (Object)e);
        }
        return properties;
    }

    public static String getProperty(String key, Properties properties) {
        return PropertyFactory.getProperty(key, properties, null);
    }

    public static String getProperty(String key, Properties properties, String defaultValue) {
        String value = System.getenv(key);
        if (!StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        value = System.getProperty(key, properties.getProperty(key));
        return !StringUtils.isEmpty((CharSequence)value) ? value : defaultValue;
    }
}

