/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.fuzzymatcher.component;

import com.intuit.fuzzymatcher.component.ElementMatch;
import com.intuit.fuzzymatcher.domain.Document;
import com.intuit.fuzzymatcher.domain.Element;
import com.intuit.fuzzymatcher.domain.Match;
import com.intuit.fuzzymatcher.domain.Score;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.BooleanUtils;

public class DocumentMatch {
    private final ElementMatch elementMatch = new ElementMatch();

    public Stream<Match<Document>> matchDocuments(Stream<Document> documents) {
        Stream<Match<Document>> documentMatch = documents.flatMap(document -> {
            Set<Element> elements = document.getPreProcessedElement();
            Set<Match<Element>> eleMatches = elements.stream().flatMap(element -> this.elementMatch.matchElement((Element)element).stream()).collect(Collectors.toSet());
            return this.documentThresholdMatching((Document)document, eleMatches);
        });
        return documentMatch;
    }

    private Stream<Match<Document>> documentThresholdMatching(Document document, Set<Match<Element>> matchingElements) {
        Map<Document, List<Match>> mathes = matchingElements.stream().collect(Collectors.groupingBy(matchElement -> ((Element)matchElement.getMatchedWith()).getDocument()));
        Stream<Match<Document>> result = mathes.entrySet().stream().flatMap(matchEntry -> {
            List<Score> childScoreList = ((List)matchEntry.getValue()).stream().map(d -> d.getScore()).collect(Collectors.toList());
            Match<Document> leftMatch = new Match<Document>(document, (Document)matchEntry.getKey(), childScoreList);
            if (leftMatch.getScore().getResult() > leftMatch.getData().getThreshold()) {
                if (BooleanUtils.isNotFalse((Boolean)((Document)matchEntry.getKey()).isSource())) {
                    Match<Document> rightMatch = new Match<Document>((Document)matchEntry.getKey(), document, childScoreList);
                    return Stream.of(leftMatch, rightMatch);
                }
                return Stream.of(leftMatch);
            }
            return Stream.empty();
        });
        return result;
    }
}

