/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.fuzzymatcher.component;

import com.intuit.fuzzymatcher.component.TokenRepo;
import com.intuit.fuzzymatcher.domain.Element;
import com.intuit.fuzzymatcher.domain.Match;
import com.intuit.fuzzymatcher.domain.Token;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;

public class ElementMatch {
    private final TokenRepo tokenRepo = new TokenRepo();

    public Set<Match<Element>> matchElement(Element element) {
        HashSet<Match<Element>> matchElements = new HashSet<Match<Element>>();
        HashMap elementTokenScore = new HashMap();
        List<Token> tokens = element.getTokens();
        tokens.stream().filter(token -> BooleanUtils.isNotFalse((Boolean)element.getDocument().isSource())).forEach(token -> this.elementThresholdMatching((Token)token, elementTokenScore, (Set<Match<Element>>)matchElements));
        tokens.forEach(token -> this.tokenRepo.put((Token)token));
        return matchElements;
    }

    private void elementThresholdMatching(Token token, Map<Element, Integer> elementTokenScore, Set<Match<Element>> matchingElements) {
        Set<Element> matchElements = this.tokenRepo.get(token);
        Element element = token.getElement();
        if (matchElements != null) {
            matchElements.forEach(matchElement -> {
                int score = elementTokenScore.getOrDefault(matchElement, 0) + 1;
                elementTokenScore.put((Element)matchElement, score);
                double elementScore = element.getScore(score, (Element)matchElement);
                if (elementScore > element.getThreshold()) {
                    Match<Element> elementMatch = new Match<Element>(element, (Element)matchElement, elementScore);
                    matchingElements.remove(elementMatch);
                    matchingElements.add(elementMatch);
                }
            });
        }
    }
}

