/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.fuzzymatcher.domain;

import com.intuit.fuzzymatcher.domain.Document;
import com.intuit.fuzzymatcher.domain.ElementClassification;
import com.intuit.fuzzymatcher.domain.ElementType;
import com.intuit.fuzzymatcher.domain.Match;
import com.intuit.fuzzymatcher.domain.MatchType;
import com.intuit.fuzzymatcher.domain.Matchable;
import com.intuit.fuzzymatcher.domain.Score;
import com.intuit.fuzzymatcher.domain.Token;
import com.intuit.fuzzymatcher.function.PreProcessFunction;
import java.util.AbstractMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class Element<T>
implements Matchable {
    private T value;
    private double weight;
    private double threshold;
    private double neighborhoodRange;
    private ElementClassification elementClassification;
    private Document document;
    private Function<T, T> preProcessFunction;
    private Function<Element<T>, Stream<Token>> tokenizerFunction;
    private List<Token> tokens;
    private MatchType matchType;
    private T preProcessedValue;

    public Element(ElementType type, String variance, T value, double weight, double threshold, double neighborhoodRange, Function<T, T> preProcessFunction, Function<Element<T>, Stream<Token>> tokenizerFunction, MatchType matchType) {
        this.weight = weight;
        this.elementClassification = new ElementClassification(type, variance);
        this.value = value;
        this.threshold = threshold;
        this.preProcessFunction = preProcessFunction == null ? type.getPreProcessFunction() : preProcessFunction;
        this.tokenizerFunction = tokenizerFunction == null ? type.getTokenizerFunction() : tokenizerFunction;
        this.matchType = matchType == null ? type.getMatchType() : matchType;
        this.neighborhoodRange = neighborhoodRange;
    }

    public ElementClassification getElementClassification() {
        return this.elementClassification;
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public double getNeighborhoodRange() {
        return this.neighborhoodRange;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public void setPreProcessedValue(T preProcessedValue) {
        this.preProcessedValue = preProcessedValue;
    }

    public Function<T, T> getPreProcessFunction() {
        return this.preProcessFunction;
    }

    public T getPreProcessedValue() {
        if (this.preProcessedValue == null) {
            if (this.value instanceof String) {
                Function<T, T> preProcessingFunc = this.getPreProcessFunction();
                this.setPreProcessedValue(preProcessingFunc.andThen(PreProcessFunction.trim()).andThen(PreProcessFunction.toLowerCase()).apply((String)this.value));
            } else {
                this.setPreProcessedValue(this.getPreProcessFunction().apply(this.value));
            }
        }
        return this.preProcessedValue;
    }

    public AbstractMap.SimpleEntry getPreprocessedValueWithType() {
        return new AbstractMap.SimpleEntry<ElementClassification, T>(this.getElementClassification(), this.getPreProcessedValue());
    }

    public Function<Element<T>, Stream<Token>> getTokenizerFunction() {
        return this.tokenizerFunction;
    }

    public MatchType getMatchType() {
        return this.matchType;
    }

    public List<Token> getTokens() {
        if (this.tokens == null) {
            this.tokens = this.getTokenizerFunction().apply(this).distinct().collect(Collectors.toList());
        }
        return this.tokens;
    }

    public double getScore(Integer matchingCount, Element other) {
        return (double)matchingCount.intValue() / (double)this.getChildCount(other);
    }

    @Override
    public long getChildCount(Matchable other) {
        if (other instanceof Element) {
            Element o = (Element)other;
            return Math.max(this.getTokens().size(), o.getTokens().size());
        }
        return 0L;
    }

    @Override
    public long getUnmatchedChildCount(Matchable other) {
        if (other instanceof Element) {
            Element o = (Element)other;
            long emptyChildren = this.getTokens().stream().filter(token -> token == null || StringUtils.isEmpty((CharSequence)token.getValue().toString())).count();
            long oEmptyChildren = o.getTokens().stream().filter(token -> token == null || StringUtils.isEmpty((CharSequence)token.getValue().toString())).count();
            return Math.max(emptyChildren, oEmptyChildren);
        }
        return 0L;
    }

    @Override
    public BiFunction<Match, List<Score>, Score> getScoringFunction() {
        return null;
    }

    public String toString() {
        return "{'" + this.value + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Element element = (Element)o;
        if (this.value != null ? !this.value.equals(element.value) : element.value != null) {
            return false;
        }
        if (this.elementClassification != null ? !this.elementClassification.equals(element.elementClassification) : element.elementClassification != null) {
            return false;
        }
        return this.document != null ? this.document.equals(element.document) : element.document == null;
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + (this.elementClassification != null ? this.elementClassification.hashCode() : 0);
        result = 31 * result + (this.document != null ? this.document.hashCode() : 0);
        return result;
    }

    public static class Builder<T> {
        private ElementType type;
        private String variance;
        private T value;
        private double weight = 1.0;
        private double threshold = 0.3;
        private double neighborhoodRange = 0.9;
        private Function<T, T> preProcessFunction;
        private MatchType matchType;
        private Function<Element<T>, Stream<Token>> tokenizerFunction;

        public Builder setType(ElementType type) {
            this.type = type;
            return this;
        }

        public Builder setVariance(String variance) {
            this.variance = variance;
            return this;
        }

        public Builder setValue(T value) {
            this.value = value;
            return this;
        }

        public Builder setWeight(double weight) {
            this.weight = weight;
            return this;
        }

        public Builder setThreshold(double threshold) {
            this.threshold = threshold;
            return this;
        }

        public Builder setNeighborhoodRange(double neighborhoodRange) {
            this.neighborhoodRange = neighborhoodRange;
            return this;
        }

        public Builder setPreProcessingFunction(Function<T, T> preProcessingFunction) {
            this.preProcessFunction = preProcessingFunction;
            return this;
        }

        public Builder setTokenizerFunction(Function<Element<T>, Stream<Token>> tokenizerFunction) {
            this.tokenizerFunction = tokenizerFunction;
            return this;
        }

        public Builder setMatchType(MatchType matchType) {
            this.matchType = matchType;
            return this;
        }

        public Element createElement() {
            return new Element<T>(this.type, this.variance, this.value, this.weight, this.threshold, this.neighborhoodRange, this.preProcessFunction, this.tokenizerFunction, this.matchType);
        }
    }
}

