/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.fuzzymatcher.function;

import com.intuit.fuzzymatcher.component.Dictionary;
import com.intuit.fuzzymatcher.util.Utils;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class PreProcessFunction<T> {
    public static Function<String, String> trim() {
        return str -> StringUtils.trim((String)str);
    }

    public static Function<String, String> toLowerCase() {
        return str -> StringUtils.lowerCase((String)str);
    }

    public static Function<String, String> numericValue() {
        return str -> str.replaceAll("[^0-9]", "");
    }

    public static Function<String, String> removeSpecialChars() {
        return str -> str.replaceAll("[^A-Za-z0-9 ]+", "");
    }

    public static Function<String, String> removeDomain() {
        return str -> {
            if (StringUtils.contains((CharSequence)str, (CharSequence)"@")) {
                int index = str.indexOf(64);
                return str.substring(0, index);
            }
            return str;
        };
    }

    public static Function<String, String> addressPreprocessing() {
        return str -> PreProcessFunction.removeSpecialChars().andThen(PreProcessFunction.addressNormalization()).apply((String)str);
    }

    public static Function<String, String> namePreprocessing() {
        return str -> PreProcessFunction.removeTrailingNumber().andThen(PreProcessFunction.removeSpecialChars()).andThen(PreProcessFunction.nameNormalization()).apply((String)str);
    }

    public static Function<String, String> addressNormalization() {
        return str -> Utils.getNormalizedString(str, Dictionary.addressDictionary);
    }

    public static Function<String, String> removeTrailingNumber() {
        return str -> str.replaceAll("\\d+$", "");
    }

    public static Function<String, String> nameNormalization() {
        return str -> Utils.getNormalizedString(str, Dictionary.nameDictionary);
    }

    public static Function<String, String> usPhoneNormalization() {
        return str -> PreProcessFunction.numericValue().andThen(s -> s.length() == 10 ? "1" + s : s).apply((String)str);
    }

    public static Function numberPreprocessing() {
        return obj -> {
            if (obj instanceof String) {
                String str = obj.toString();
                Pattern pattern = Pattern.compile("-?\\d+(\\.\\d+)?");
                Matcher matcher = pattern.matcher(str);
                return matcher.find() ? matcher.group() : str;
            }
            return PreProcessFunction.none().apply(obj);
        };
    }

    public static Function none() {
        return obj -> obj;
    }
}

