/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.fuzzymatcher.component;

import com.intuit.fuzzymatcher.exception.MatchException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dictionary {
    private static final Logger LOGGER = LoggerFactory.getLogger(Dictionary.class);
    public static final Map<String, String> addressDictionary = Dictionary.getAddressDictionary();
    public static final Map<String, String> nameDictionary = Dictionary.getNameDictionary();

    private static Map<String, String> getAddressDictionary() {
        try {
            ClassLoader classLoader = Dictionary.class.getClassLoader();
            BufferedReader br = new BufferedReader(new InputStreamReader(classLoader.getResourceAsStream("address-dictionary.txt")));
            return Dictionary.getDictionary(br);
        }
        catch (IOException e) {
            LOGGER.error("could not load address dictonary", (Throwable)e);
            throw new MatchException("could not load address dictonary", e);
        }
    }

    private static Map<String, String> getNameDictionary() {
        try {
            ClassLoader classLoader = Dictionary.class.getClassLoader();
            BufferedReader br = new BufferedReader(new InputStreamReader(classLoader.getResourceAsStream("name-dictionary.txt")));
            return Dictionary.getDictionary(br);
        }
        catch (IOException e) {
            LOGGER.error("could not load name dictonary", (Throwable)e);
            throw new MatchException("could not load name dictonary", e);
        }
    }

    private static Map<String, String> getDictionary(BufferedReader br) throws IOException {
        return br.lines().map(String::toLowerCase).map(s -> s.split(":", 2)).collect(Collectors.toMap(arr -> arr[0].trim(), arr -> arr[1].trim(), (a1, a2) -> a1));
    }
}

