/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.fuzzymatcher.domain;

import com.intuit.fuzzymatcher.domain.Element;
import com.intuit.fuzzymatcher.domain.Match;
import com.intuit.fuzzymatcher.domain.Matchable;
import com.intuit.fuzzymatcher.domain.Score;
import com.intuit.fuzzymatcher.function.ScoringFunction;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class Document
implements Matchable {
    private String key;
    private Set<Element> elements;
    private Set<Element> preProcessedElement;
    private double threshold;
    private Boolean source;
    private static final BiFunction<Match, List<Score>, Score> DEFAULT_DOCUMENT_SCORING = ScoringFunction.getExponentialWeightedAverageScore();

    private Document(String key, Set<Element> elements, double threshold) {
        this.key = key;
        this.elements = elements;
        this.threshold = threshold;
    }

    public String getKey() {
        return this.key;
    }

    public Set<Element> getElements() {
        return this.elements;
    }

    public Set<Element> getPreProcessedElement() {
        if (this.preProcessedElement == null) {
            this.preProcessedElement = this.getDistinctNonEmptyElements().collect(Collectors.toSet());
        }
        return this.preProcessedElement;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public Stream<Element> getDistinctElements() {
        return this.elements.stream().filter(Document.distinctByKey(Element::getPreprocessedValueWithType));
    }

    public Stream<Element> getDistinctNonEmptyElements() {
        return this.getDistinctElements().filter(m -> {
            if (m.getPreProcessedValue() instanceof String) {
                return !StringUtils.isEmpty((CharSequence)m.getPreProcessedValue().toString());
            }
            return m.getPreProcessedValue() != null;
        });
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    @Override
    public long getChildCount(Matchable other) {
        if (other instanceof Document) {
            Document o = (Document)other;
            List childrenType = this.getPreProcessedElement().stream().map(Element::getElementClassification).collect(Collectors.toList());
            List oChildrenType = o.getPreProcessedElement().stream().map(Element::getElementClassification).collect(Collectors.toList());
            return CollectionUtils.union(childrenType, oChildrenType).size();
        }
        return 0L;
    }

    @Override
    public long getUnmatchedChildCount(Matchable other) {
        if (other instanceof Document) {
            Document o = (Document)other;
            List childrenType = this.getPreProcessedElement().stream().map(Element::getElementClassification).collect(Collectors.toList());
            List oChildrenType = o.getPreProcessedElement().stream().map(Element::getElementClassification).collect(Collectors.toList());
            return CollectionUtils.disjunction(childrenType, oChildrenType).size();
        }
        return 0L;
    }

    @Override
    public BiFunction<Match, List<Score>, Score> getScoringFunction() {
        return DEFAULT_DOCUMENT_SCORING;
    }

    @Override
    public double getWeight() {
        return 1.0;
    }

    public Boolean isSource() {
        return this.source;
    }

    public void setSource(Boolean source) {
        this.source = source;
    }

    public String toString() {
        return "{" + this.getOrderedElements(this.elements) + "}";
    }

    public List<Element> getOrderedElements(Set<Element> elements) {
        return elements.stream().sorted(Comparator.comparing(ele -> ele.getElementClassification().getElementType())).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Document document = (Document)o;
        return this.key.equals(document.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public static class Builder {
        private String key;
        private Set<Element> elements;
        private double threshold = 0.5;

        public Builder(String key) {
            this.key = key;
        }

        public Builder setThreshold(double threshold) {
            this.threshold = threshold;
            return this;
        }

        public Builder addElement(Element element) {
            if (this.elements == null || this.elements.isEmpty()) {
                this.elements = new HashSet<Element>();
            }
            this.elements.add(element);
            return this;
        }

        public Document createDocument() {
            Document doc = new Document(this.key, this.elements, this.threshold);
            doc.elements.stream().forEach(element -> element.setDocument(doc));
            return doc;
        }
    }
}

