/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.fuzzymatcher.function;

import com.intuit.fuzzymatcher.domain.Match;
import com.intuit.fuzzymatcher.domain.Matchable;
import com.intuit.fuzzymatcher.domain.Score;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public interface ScoringFunction
extends BiFunction<Match, List<Score>, Score> {
    public static final double EXPONENT = 1.5;
    public static final double EXPONENTIAL_INCREASE_THRESHOLD = 0.9;
    public static final double DEFAULT_UNMATCHED_CHILD_SCORE = 0.5;

    public static ScoringFunction getAverageScore() {
        return (match, childScores) -> {
            double numerator = ScoringFunction.getSumOfResult(childScores) + ScoringFunction.getUnmatchedChildScore(match);
            double denominator = ScoringFunction.getChildCount(match);
            return new Score(numerator / denominator, (Match)match);
        };
    }

    public static ScoringFunction getSimpleAverageScore() {
        return (match, childScores) -> {
            double numerator = ScoringFunction.getSumOfResult(childScores);
            double denominator = ScoringFunction.getChildCount(match);
            return new Score(numerator / denominator, (Match)match);
        };
    }

    public static ScoringFunction getWeightedAverageScore() {
        return (match, childScores) -> {
            double numerator = ScoringFunction.getSumOfWeightedResult(childScores) + ScoringFunction.getUnmatchedChildScore(match);
            double denominator = ScoringFunction.getSumOfWeights(childScores) + ScoringFunction.getChildCount(match) - (double)childScores.size();
            return new Score(numerator / denominator, (Match)match);
        };
    }

    public static ScoringFunction getExponentialAverageScore() {
        return (match, childScores) -> {
            List<Score> perfectMatchedElements = ScoringFunction.getPerfectMatchedElement(childScores);
            if (perfectMatchedElements.size() > 1 && ScoringFunction.getSumOfResult(perfectMatchedElements) > 1.0) {
                double numerator = ScoringFunction.getExponentiallyIncreasedValue(ScoringFunction.getSumOfResult(perfectMatchedElements)) + ScoringFunction.getSumOfResult(ScoringFunction.getNonPerfectMatchedElement(childScores)) + ScoringFunction.getUnmatchedChildScore(match);
                double denominator = ScoringFunction.getExponentiallyIncreasedValue(perfectMatchedElements.size()) + ScoringFunction.getChildCount(match) - (double)perfectMatchedElements.size();
                return new Score(numerator / denominator, (Match)match);
            }
            return (Score)ScoringFunction.getAverageScore().apply(match, childScores);
        };
    }

    public static ScoringFunction getExponentialWeightedAverageScore() {
        return (match, childScores) -> {
            List<Score> perfectMatchedElements = ScoringFunction.getPerfectMatchedElement(childScores);
            if (perfectMatchedElements.size() > 1 && ScoringFunction.getSumOfWeightedResult(perfectMatchedElements) > 1.0) {
                List<Score> notPerfectMachedElements = ScoringFunction.getNonPerfectMatchedElement(childScores);
                double numerator = ScoringFunction.getExponentiallyIncreasedValue(ScoringFunction.getSumOfWeightedResult(perfectMatchedElements)) + ScoringFunction.getSumOfWeightedResult(notPerfectMachedElements) + ScoringFunction.getUnmatchedChildScore(match);
                double denominator = ScoringFunction.getExponentiallyIncreasedValue(ScoringFunction.getSumOfWeights(perfectMatchedElements)) + ScoringFunction.getSumOfWeights(notPerfectMachedElements) + ScoringFunction.getChildCount(match) - (double)childScores.size();
                return new Score(numerator / denominator, (Match)match);
            }
            return (Score)ScoringFunction.getWeightedAverageScore().apply(match, childScores);
        };
    }

    public static double getSumOfWeightedResult(List<Score> childScoreList) {
        return childScoreList.stream().mapToDouble(d -> d.getResult() * d.getMatch().getWeight()).sum();
    }

    public static double getSumOfResult(List<Score> childScoreList) {
        return childScoreList.stream().mapToDouble(d -> d.getResult()).sum();
    }

    public static double getSumOfWeights(List<Score> childScoreList) {
        return childScoreList.stream().mapToDouble(d -> d.getMatch().getWeight()).sum();
    }

    public static double getExponentiallyIncreasedValue(double value) {
        return Math.pow(value, 1.5);
    }

    public static List<Score> getNonPerfectMatchedElement(List<Score> childScoreList) {
        return childScoreList.stream().filter(d -> d.getResult() < 0.9).collect(Collectors.toList());
    }

    public static List<Score> getPerfectMatchedElement(List<Score> childScoreList) {
        return childScoreList.stream().filter(d -> d.getResult() >= 0.9).collect(Collectors.toList());
    }

    public static double getChildCount(Match match) {
        return match.getData().getChildCount((Matchable)match.getMatchedWith());
    }

    public static double getUnmatchedChildScore(Match match) {
        long maxUnmatchedChildCount = match.getData().getUnmatchedChildCount((Matchable)match.getMatchedWith());
        return 0.5 * (double)maxUnmatchedChildCount;
    }
}

