/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.fuzzymatcher.function;

import com.intuit.fuzzymatcher.domain.Element;
import com.intuit.fuzzymatcher.domain.Token;
import com.intuit.fuzzymatcher.exception.MatchException;
import com.intuit.fuzzymatcher.util.Utils;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.codec.language.Soundex;

public class TokenizerFunction {
    private static final Soundex soundex = new Soundex();

    public static Function<Element, Stream<Token>> valueTokenizer() {
        return element -> Stream.of(new Token(element.getPreProcessedValue(), (Element)element));
    }

    public static Function<Element<String>, Stream<Token<String>>> wordTokenizer() {
        return element -> Arrays.stream(((String)element.getPreProcessedValue()).split("\\s+")).map(token -> new Token<String>((String)token, (Element)element));
    }

    public static Function<Element<String>, Stream<Token<String>>> wordSoundexEncodeTokenizer() {
        return element -> Arrays.stream(((String)element.getPreProcessedValue()).toString().split("\\s+")).map(val -> {
            String code = val;
            if (!Utils.isNumeric(val) && (code = soundex.encode(val)).equals("")) {
                code = val;
            }
            return code;
        }).map(token -> new Token<String>((String)token, (Element)element));
    }

    public static Function<Element<String>, Stream<Token<String>>> triGramTokenizer() {
        return element -> TokenizerFunction.getNGramTokens(3, element);
    }

    public static Function<Element<String>, Stream<Token<String>>> decaGramTokenizer() {
        return element -> TokenizerFunction.getNGramTokens(10, element);
    }

    public static Stream<Token<String>> getNGramTokens(int size, Element element) {
        Object elementValue = element.getPreProcessedValue();
        if (!(elementValue instanceof String)) {
            throw new MatchException("Unsupported data type");
        }
        String elementValueStr = (String)elementValue;
        return Utils.getNGrams(elementValueStr, size).map(str -> new Token<String>((String)str, element));
    }

    public static Function<Element<String>, Stream<Token<String>>> chainTokenizers(Function<Element<String>, Stream<Token<String>>> ... tokenizers) {
        return element -> Arrays.stream(tokenizers).flatMap(fun -> (Stream)fun.apply(element));
    }
}

