/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.graphql.adapter.rest;

import com.intuit.graphql.adapter.core.ServiceAdapter;
import com.intuit.graphql.adapter.core.ServiceAdapterException;
import com.intuit.graphql.adapter.core.ServiceAdapterRequest;
import com.intuit.graphql.adapter.core.ServiceAdapterResponse;
import com.intuit.graphql.adapter.rest.ServiceLoader;
import com.intuit.graphql.adapter.rest.utils.ServiceEvaluatorUtils;
import com.intuit.service.dsl.evaluator.ServiceConfiguration;
import com.intuit.service.dsl.evaluator.ServiceEvaluator;
import com.intuit.service.dsl.evaluator.ServiceEvaluatorRequest;
import graphql.GraphQLContext;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.server.ServerRequest;
import reactor.util.context.Context;

public class RestAdapter
implements ServiceAdapter {
    private final ServiceConfiguration serviceConfiguration;
    private final WebClient webClient;
    private final String serviceId;
    private final ServiceLoader serviceLoader;

    private RestAdapter(String dslResource, String serviceId, ServiceConfiguration svcConfig, WebClient webClient) {
        Objects.requireNonNull(dslResource, "dslResource");
        Objects.requireNonNull(serviceId, "serviceId");
        Objects.requireNonNull(svcConfig, "svcConfig");
        Objects.requireNonNull(webClient, "webClient");
        this.serviceConfiguration = svcConfig;
        this.webClient = webClient;
        this.serviceId = serviceId;
        this.serviceLoader = new ServiceLoader(dslResource);
    }

    public CompletableFuture<ServiceAdapterResponse> execute(ServiceAdapterRequest request) {
        GraphQLContext graphQLcontext = request.getGraphQLContext();
        ServerRequest serverRequest = (ServerRequest)graphQLcontext.get(ServerRequest.class);
        Objects.requireNonNull(serverRequest, "ServerRequest is null");
        Context reactorContext = (Context)graphQLcontext.get(Context.class);
        Objects.requireNonNull(reactorContext, "ReactorContext is null");
        ServiceEvaluatorRequest serviceEvaluatorRequest = ServiceEvaluatorRequest.builder().inputMap(request.getInputMap()).reactorContext(reactorContext).serviceName(request.getAdapter()).service(this.serviceLoader.getService(request.getAdapter().orElse(null))).build();
        return ServiceEvaluator.builder().serviceConfiguration(this.serviceConfiguration).webClient(this.webClient).build().evaluate(serviceEvaluatorRequest).handle((serviceEvaluatorResponse, throwable) -> {
            if (Objects.nonNull(throwable)) {
                String message = "Error calling rest provider. ";
                throw new ServiceAdapterException(message + throwable.getMessage(), throwable);
            }
            try {
                return ServiceEvaluatorUtils.toServiceAdapterResponse(request.getRequestedField(), serviceEvaluatorResponse);
            }
            catch (Throwable ex) {
                String message = "Error processing json response. ";
                throw new ServiceAdapterException(message + ex.getMessage(), ex);
            }
        });
    }

    @Generated
    public static RestAdapterBuilder builder() {
        return new RestAdapterBuilder();
    }

    @Generated
    public static class RestAdapterBuilder {
        @Generated
        private String dslResource;
        @Generated
        private String serviceId;
        @Generated
        private ServiceConfiguration svcConfig;
        @Generated
        private WebClient webClient;

        @Generated
        RestAdapterBuilder() {
        }

        @Generated
        public RestAdapterBuilder dslResource(String dslResource) {
            this.dslResource = dslResource;
            return this;
        }

        @Generated
        public RestAdapterBuilder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        @Generated
        public RestAdapterBuilder svcConfig(ServiceConfiguration svcConfig) {
            this.svcConfig = svcConfig;
            return this;
        }

        @Generated
        public RestAdapterBuilder webClient(WebClient webClient) {
            this.webClient = webClient;
            return this;
        }

        @Generated
        public RestAdapter build() {
            return new RestAdapter(this.dslResource, this.serviceId, this.svcConfig, this.webClient);
        }

        @Generated
        public String toString() {
            return "RestAdapter.RestAdapterBuilder(dslResource=" + this.dslResource + ", serviceId=" + this.serviceId + ", svcConfig=" + this.svcConfig + ", webClient=" + this.webClient + ")";
        }
    }
}

