/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.graphql.scoping;

import com.intuit.graphql.graphQL.ArgumentsDefinition;
import com.intuit.graphql.graphQL.Directive;
import com.intuit.graphql.graphQL.DirectiveDefinition;
import com.intuit.graphql.graphQL.DirectiveLocation;
import com.intuit.graphql.graphQL.GraphQLFactory;
import com.intuit.graphql.graphQL.GraphQLPackage;
import com.intuit.graphql.graphQL.InputValueDefinition;
import com.intuit.graphql.graphQL.PrimitiveType;
import com.intuit.graphql.graphQL.TypeSystem;
import com.intuit.graphql.graphQL.TypeSystemDefinition;
import com.intuit.graphql.graphQL.Value;
import com.intuit.graphql.scoping.AbstractGraphQLScopeProvider;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;

public class GraphQLScopeProvider
extends AbstractGraphQLScopeProvider {
    private Map<String, Function<String, DirectiveDefinition>> BUILT_IN_DIRECTIVE_DEFINITIONS = new HashMap(){
        {
            this.put("include", createFilterableDirective);
            this.put("skip", createFilterableDirective);
            this.put("deprecated", createDeprecatedDirective);
        }
    };
    private static Function<String, DirectiveDefinition> createDeprecatedDirective = directiveName -> {
        PrimitiveType primitive = GraphQLFactory.eINSTANCE.createPrimitiveType();
        primitive.setType("String");
        Value value = GraphQLFactory.eINSTANCE.createValue();
        value.setStringValue("No longer supported");
        InputValueDefinition input = GraphQLFactory.eINSTANCE.createInputValueDefinition();
        input.setName("reason");
        input.setNamedType(primitive);
        input.setDefaultValue(value);
        ArgumentsDefinition arguments = GraphQLFactory.eINSTANCE.createArgumentsDefinition();
        arguments.getInputValueDefinition().add((Object)input);
        DirectiveDefinition deprecated = GraphQLFactory.eINSTANCE.createDirectiveDefinition();
        deprecated.setName("deprecated");
        deprecated.setArgumentsDefinition(arguments);
        deprecated.getDirectiveLocations().addAll(Arrays.asList(GraphQLScopeProvider.createDirectiveLocation("FIELD_DEFINITION"), GraphQLScopeProvider.createDirectiveLocation("ENUM_VALUE")));
        return deprecated;
    };
    private static Function<String, DirectiveDefinition> createFilterableDirective = directiveName -> {
        PrimitiveType primitive = GraphQLFactory.eINSTANCE.createPrimitiveType();
        primitive.setType("Boolean");
        primitive.setNonNull(true);
        InputValueDefinition input = GraphQLFactory.eINSTANCE.createInputValueDefinition();
        input.setName("if");
        input.setNamedType(primitive);
        ArgumentsDefinition arguments = GraphQLFactory.eINSTANCE.createArgumentsDefinition();
        arguments.getInputValueDefinition().add((Object)input);
        DirectiveDefinition directive = GraphQLFactory.eINSTANCE.createDirectiveDefinition();
        directive.setName((String)directiveName);
        directive.setArgumentsDefinition(arguments);
        directive.getDirectiveLocations().addAll(Arrays.asList(GraphQLScopeProvider.createDirectiveLocation("FIELD"), GraphQLScopeProvider.createDirectiveLocation("FRAGMENT_SPREAD"), GraphQLScopeProvider.createDirectiveLocation("INLINE_FRAGMENT")));
        return directive;
    };

    private static DirectiveLocation createDirectiveLocation(String location) {
        DirectiveLocation directiveLocation = GraphQLFactory.eINSTANCE.createDirectiveLocation();
        directiveLocation.setNamedDirective(location);
        return directiveLocation;
    }

    private TypeSystemDefinition typeSystemDefinition(DirectiveDefinition directiveDefinition) {
        TypeSystemDefinition typeSystemDefinition = GraphQLFactory.eINSTANCE.createTypeSystemDefinition();
        typeSystemDefinition.setDirective(directiveDefinition);
        return typeSystemDefinition;
    }

    public IScope getScope(EObject context, EReference reference) {
        EObject rootContainer;
        if (context instanceof Directive && reference == GraphQLPackage.Literals.DIRECTIVE__DEFINITION && (rootContainer = EcoreUtil2.getRootContainer((EObject)context)) instanceof TypeSystem) {
            TypeSystem typeSystem = (TypeSystem)EcoreUtil2.getRootContainer((EObject)context);
            Map existingDirectives = typeSystem.getTypeSystemDefinition().stream().filter(t -> Objects.nonNull(t.getDirective())).map(ts -> ts.getDirective()).collect(Collectors.toMap(d -> d.getName(), Function.identity()));
            this.BUILT_IN_DIRECTIVE_DEFINITIONS.forEach((key, value) -> {
                if (!existingDirectives.containsKey(key)) {
                    DirectiveDefinition def = (DirectiveDefinition)value.apply(key);
                    existingDirectives.put((String)key, def);
                    context.eResource().getContents().add((Object)def);
                    typeSystem.getTypeSystemDefinition().add((Object)this.typeSystemDefinition(def));
                }
            });
            return Scopes.scopeFor(existingDirectives.values());
        }
        return super.getScope(context, reference);
    }
}

