/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.graphql.utils;

import com.intuit.graphql.graphQL.InterfaceTypeDefinition;
import com.intuit.graphql.graphQL.ListType;
import com.intuit.graphql.graphQL.NamedType;
import com.intuit.graphql.graphQL.ObjectType;
import com.intuit.graphql.graphQL.PrimitiveType;
import com.intuit.graphql.graphQL.TypeDefinition;
import com.intuit.graphql.graphQL.UnionTypeDefinition;
import java.util.Objects;

public class XtextTypeUtils {
    public static boolean isNotWrapped(NamedType type) {
        return !XtextTypeUtils.isWrapped(type);
    }

    public static boolean isWrapped(NamedType type) {
        return XtextTypeUtils.isListType(type);
    }

    public static boolean isNonNull(NamedType type) {
        return type.isNonNull();
    }

    public static boolean isListType(NamedType type) {
        return type instanceof ListType;
    }

    public static NamedType unwrapOne(NamedType type) {
        if (XtextTypeUtils.isListType(type)) {
            return ((ListType)type).getType();
        }
        return type;
    }

    public static NamedType unwrapAll(NamedType type) {
        while (!XtextTypeUtils.isNotWrapped(type)) {
            type = XtextTypeUtils.unwrapOne(type);
        }
        return type;
    }

    public static String typeName(NamedType type) {
        if ((type = XtextTypeUtils.unwrapAll(type)) instanceof PrimitiveType) {
            return ((PrimitiveType)type).getType();
        }
        return ((ObjectType)type).getType().getName();
    }

    public static TypeDefinition getObjectType(NamedType type) {
        if (Objects.nonNull(type) && type instanceof ObjectType) {
            return ((ObjectType)type).getType();
        }
        return null;
    }

    public static boolean isInterfaceOrUnionType(NamedType type) {
        TypeDefinition typeDefinition = XtextTypeUtils.getObjectType(type);
        if (Objects.nonNull(typeDefinition)) {
            return typeDefinition instanceof InterfaceTypeDefinition || typeDefinition instanceof UnionTypeDefinition;
        }
        return false;
    }
}

