/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.graphql.validation;

import com.intuit.graphql.graphQL.NamedType;
import com.intuit.graphql.graphQL.ObjectType;
import com.intuit.graphql.graphQL.ObjectTypeDefinition;
import com.intuit.graphql.graphQL.UnionTypeDefinition;
import com.intuit.graphql.utils.XtextTypeUtils;
import com.intuit.graphql.validation.BaseValidation;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.validation.Check;

class UnionTypeValidation
extends BaseValidation {
    UnionTypeValidation() {
    }

    @Check
    public void checkIfMembersAreObjectTypes(UnionTypeDefinition unionTypeDefinition) {
        if (Objects.isNull(unionTypeDefinition.getUnionMemberShip())) {
            return;
        }
        EList<NamedType> members = unionTypeDefinition.getUnionMemberShip().getUnionMembers().getNamedUnion();
        for (NamedType namedType : members) {
            if (this.isGraphQLObjectType(namedType)) continue;
            this.error("Offending member type in union '" + XtextTypeUtils.typeName(namedType) + "'", unionTypeDefinition);
        }
    }

    private boolean isGraphQLObjectType(NamedType namedType) {
        return namedType instanceof ObjectType && ((ObjectType)namedType).getType() instanceof ObjectTypeDefinition;
    }
}

