/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.graphql.authorization.enforcement;

import com.intuit.graphql.authorization.config.AuthzClientConfiguration;
import com.intuit.graphql.authorization.enforcement.AuthorizationHolder;
import com.intuit.graphql.authorization.enforcement.AuthzListener;
import com.intuit.graphql.authorization.enforcement.IntrospectionRedactingDataFetcher;
import com.intuit.graphql.authorization.enforcement.RedactingVisitor;
import com.intuit.graphql.authorization.enforcement.SimpleAuthZListener;
import com.intuit.graphql.authorization.enforcement.TypeFieldPermissionVerifier;
import com.intuit.graphql.authorization.rules.AuthorizationHolderFactory;
import com.intuit.graphql.authorization.rules.QueryRuleParser;
import com.intuit.graphql.authorization.rules.RuleParser;
import com.intuit.graphql.authorization.util.GraphQLUtil;
import com.intuit.graphql.authorization.util.PrincipleFetcher;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLError;
import graphql.analysis.QueryTransformer;
import graphql.analysis.QueryVisitor;
import graphql.execution.ExecutionContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimpleInstrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationCreateStateParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.language.FragmentDefinition;
import graphql.language.Node;
import graphql.language.SelectionSet;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthzInstrumentation
extends SimpleInstrumentation {
    private static final Logger log = LoggerFactory.getLogger(AuthzInstrumentation.class);
    private static final AuthzListener DEFAULT_AUTHZ_LISTENER = new SimpleAuthZListener();
    private final AuthorizationHolder authorizationHolder;
    private final PrincipleFetcher principleFetcher;
    private AuthzListener authzListener = DEFAULT_AUTHZ_LISTENER;

    static AuthorizationHolderFactory getAuthorizationFactory(GraphQLSchema graphQLSchema) {
        QueryRuleParser queryRuleParser = new QueryRuleParser(graphQLSchema);
        HashSet<RuleParser> hash_Set = new HashSet<RuleParser>();
        hash_Set.add(queryRuleParser);
        return new AuthorizationHolderFactory(hash_Set);
    }

    public AuthzInstrumentation(AuthzClientConfiguration configuration, GraphQLSchema schema, PrincipleFetcher principleFetcher, AuthzListener authzListener) {
        if (configuration.getQueriesByClient().isEmpty()) {
            throw new IllegalArgumentException("Clients missing from AuthZClientConfiguration");
        }
        this.authorizationHolder = new AuthorizationHolder(AuthzInstrumentation.getAuthorizationFactory(schema).parse(configuration.getQueriesByClient()));
        this.principleFetcher = principleFetcher;
        this.authzListener = Objects.nonNull(authzListener) ? authzListener : DEFAULT_AUTHZ_LISTENER;
    }

    public AuthzInstrumentationState createState(InstrumentationCreateStateParameters parameters) {
        Set<String> scopes = this.principleFetcher.getScopes(parameters.getExecutionInput().getContext());
        boolean enforce = !this.principleFetcher.authzEnforcementExemption(parameters.getExecutionInput().getContext()) && CollectionUtils.isNotEmpty(scopes);
        this.authzListener.onCreatingState(enforce, parameters.getSchema(), parameters.getExecutionInput());
        return new AuthzInstrumentationState(this.authorizationHolder.getPermissionsVerifier(scopes, parameters.getSchema()), parameters.getSchema(), scopes, enforce);
    }

    public ExecutionContext instrumentExecutionContext(ExecutionContext executionContext, InstrumentationExecutionParameters parameters) {
        AuthzInstrumentationState state = (AuthzInstrumentationState)parameters.getInstrumentationState();
        ExecutionContext enforcedExecutionContext = state.isEnforce() ? this.getAuthzExecutionContext(executionContext, state) : executionContext;
        this.authzListener.onEnforcement(state.isEnforce(), executionContext, enforcedExecutionContext);
        return enforcedExecutionContext;
    }

    private ExecutionContext getAuthzExecutionContext(ExecutionContext executionContext, AuthzInstrumentationState state) {
        log.info("Authorization is enabled");
        ExecutionContext restrictedContext = executionContext.transform(executionContextBuilder -> executionContextBuilder.operationDefinition(executionContext.getOperationDefinition().transform(operationDefinitionBuilder -> operationDefinitionBuilder.selectionSet(this.redactSelectionSet(executionContext, state)))).fragmentsByName(this.redactFragments(executionContext, state)));
        log.info("Restricted executionContext created");
        return restrictedContext;
    }

    public CompletableFuture<ExecutionResult> instrumentExecutionResult(ExecutionResult executionResult, InstrumentationExecutionParameters parameters) {
        AuthzInstrumentationState instrumentationState = (AuthzInstrumentationState)parameters.getInstrumentationState();
        List graphQLErrors = executionResult.getErrors();
        if (CollectionUtils.isNotEmpty(instrumentationState.getAuthzErrors())) {
            graphQLErrors = Stream.concat(graphQLErrors.stream(), instrumentationState.getAuthzErrors().stream()).collect(Collectors.toList());
        }
        if (executionResult.getData() == null) {
            return CompletableFuture.completedFuture(new ExecutionResultImpl(graphQLErrors));
        }
        return CompletableFuture.completedFuture(new ExecutionResultImpl(executionResult.getData(), graphQLErrors, executionResult.getExtensions()));
    }

    private QueryTransformer.Builder initQueryTransformerBuilder(ExecutionContext executionContext) {
        return QueryTransformer.newQueryTransformer().schema(executionContext.getGraphQLSchema()).variables(executionContext.getVariables()).fragmentsByName(executionContext.getFragmentsByName());
    }

    Map<String, FragmentDefinition> redactFragments(ExecutionContext executionContext, AuthzInstrumentationState state) {
        return executionContext.getFragmentsByName().values().stream().map(entry -> this.redactFragment((FragmentDefinition)entry, executionContext, state)).collect(Collectors.toMap(FragmentDefinition::getName, Function.identity()));
    }

    FragmentDefinition redactFragment(FragmentDefinition fragmentDefinition, ExecutionContext executionContext, AuthzInstrumentationState state) {
        fragmentDefinition.getTypeCondition();
        QueryTransformer queryTransformer = this.initQueryTransformerBuilder(executionContext).root((Node)fragmentDefinition).rootParentType((GraphQLCompositeType)executionContext.getGraphQLSchema().getQueryType()).build();
        return (FragmentDefinition)queryTransformer.transform((QueryVisitor)new RedactingVisitor(state, executionContext, this.authzListener));
    }

    SelectionSet redactSelectionSet(ExecutionContext executionContext, AuthzInstrumentationState state) {
        GraphQLObjectType rootType = GraphQLUtil.getRootTypeFromOperation(executionContext.getOperationDefinition(), executionContext.getGraphQLSchema());
        QueryTransformer transformer = this.initQueryTransformerBuilder(executionContext).rootParentType((GraphQLCompositeType)rootType).root((Node)executionContext.getOperationDefinition().getSelectionSet()).build();
        return (SelectionSet)transformer.transform((QueryVisitor)new RedactingVisitor(state, executionContext, this.authzListener));
    }

    public DataFetcher<?> instrumentDataFetcher(DataFetcher<?> dataFetcher, InstrumentationFieldFetchParameters parameters) {
        AuthzInstrumentationState state = (AuthzInstrumentationState)parameters.getInstrumentationState();
        return state.isEnforce() ? new IntrospectionRedactingDataFetcher(dataFetcher, state) : dataFetcher;
    }

    static class AuthzInstrumentationState
    implements InstrumentationState {
        private List<GraphQLError> authzErrors = new LinkedList<GraphQLError>();
        private final TypeFieldPermissionVerifier typeFieldPermissionVerifier;
        private final GraphQLSchema graphQLSchema;
        private final Set<String> scopes;
        private final boolean enforce;

        public List<GraphQLError> getAuthzErrors() {
            return this.authzErrors;
        }

        public TypeFieldPermissionVerifier getTypeFieldPermissionVerifier() {
            return this.typeFieldPermissionVerifier;
        }

        public GraphQLSchema getGraphQLSchema() {
            return this.graphQLSchema;
        }

        public Set<String> getScopes() {
            return this.scopes;
        }

        public boolean isEnforce() {
            return this.enforce;
        }

        public void setAuthzErrors(List<GraphQLError> authzErrors) {
            this.authzErrors = authzErrors;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AuthzInstrumentationState)) {
                return false;
            }
            AuthzInstrumentationState other = (AuthzInstrumentationState)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<GraphQLError> this$authzErrors = this.getAuthzErrors();
            List<GraphQLError> other$authzErrors = other.getAuthzErrors();
            if (this$authzErrors == null ? other$authzErrors != null : !((Object)this$authzErrors).equals(other$authzErrors)) {
                return false;
            }
            TypeFieldPermissionVerifier this$typeFieldPermissionVerifier = this.getTypeFieldPermissionVerifier();
            TypeFieldPermissionVerifier other$typeFieldPermissionVerifier = other.getTypeFieldPermissionVerifier();
            if (this$typeFieldPermissionVerifier == null ? other$typeFieldPermissionVerifier != null : !this$typeFieldPermissionVerifier.equals(other$typeFieldPermissionVerifier)) {
                return false;
            }
            GraphQLSchema this$graphQLSchema = this.getGraphQLSchema();
            GraphQLSchema other$graphQLSchema = other.getGraphQLSchema();
            if (this$graphQLSchema == null ? other$graphQLSchema != null : !this$graphQLSchema.equals(other$graphQLSchema)) {
                return false;
            }
            Set<String> this$scopes = this.getScopes();
            Set<String> other$scopes = other.getScopes();
            if (this$scopes == null ? other$scopes != null : !((Object)this$scopes).equals(other$scopes)) {
                return false;
            }
            return this.isEnforce() == other.isEnforce();
        }

        protected boolean canEqual(Object other) {
            return other instanceof AuthzInstrumentationState;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<GraphQLError> $authzErrors = this.getAuthzErrors();
            result = result * 59 + ($authzErrors == null ? 43 : ((Object)$authzErrors).hashCode());
            TypeFieldPermissionVerifier $typeFieldPermissionVerifier = this.getTypeFieldPermissionVerifier();
            result = result * 59 + ($typeFieldPermissionVerifier == null ? 43 : $typeFieldPermissionVerifier.hashCode());
            GraphQLSchema $graphQLSchema = this.getGraphQLSchema();
            result = result * 59 + ($graphQLSchema == null ? 43 : $graphQLSchema.hashCode());
            Set<String> $scopes = this.getScopes();
            result = result * 59 + ($scopes == null ? 43 : ((Object)$scopes).hashCode());
            result = result * 59 + (this.isEnforce() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "AuthzInstrumentation.AuthzInstrumentationState(authzErrors=" + this.getAuthzErrors() + ", typeFieldPermissionVerifier=" + this.getTypeFieldPermissionVerifier() + ", graphQLSchema=" + this.getGraphQLSchema() + ", scopes=" + this.getScopes() + ", enforce=" + this.isEnforce() + ")";
        }

        public AuthzInstrumentationState(TypeFieldPermissionVerifier typeFieldPermissionVerifier, GraphQLSchema graphQLSchema, Set<String> scopes, boolean enforce) {
            this.typeFieldPermissionVerifier = typeFieldPermissionVerifier;
            this.graphQLSchema = graphQLSchema;
            this.scopes = scopes;
            this.enforce = enforce;
        }
    }
}

