/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.graphql.authorization.enforcement;

import com.intuit.graphql.authorization.enforcement.AuthzInstrumentation;
import com.intuit.graphql.authorization.util.GraphQLUtil;
import graphql.introspection.Introspection;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLType;
import java.util.List;
import java.util.stream.Collectors;

class IntrospectionRedactingDataFetcher
implements DataFetcher {
    private final DataFetcher delegate;
    private final AuthzInstrumentation.AuthzInstrumentationState state;

    public IntrospectionRedactingDataFetcher(DataFetcher delegate, AuthzInstrumentation.AuthzInstrumentationState state) {
        this.state = state;
        this.delegate = delegate;
    }

    public Object get(DataFetchingEnvironment environment) throws Exception {
        Object delegatedGetResult = this.delegate.get(environment);
        if (delegatedGetResult != null) {
            if (GraphQLUtil.isListOfIntrospection__Type((GraphQLType)environment.getFieldType())) {
                return this.redactTypeList((List)delegatedGetResult);
            }
            if (this.delegate == this.fieldsDataFetcher(environment)) {
                Object type = environment.getSource();
                return this.redactFields((List)delegatedGetResult, (GraphQLFieldsContainer)type);
            }
        }
        return delegatedGetResult;
    }

    private DataFetcher fieldsDataFetcher(DataFetchingEnvironment environment) {
        return environment.getGraphQLSchema().getCodeRegistry().getDataFetcher((GraphQLFieldsContainer)Introspection.__Type, Introspection.__Type.getFieldDefinition("fields"));
    }

    private List<GraphQLFieldDefinition> redactFields(List<GraphQLFieldDefinition> fields, GraphQLFieldsContainer fieldsContainer) {
        return fields.stream().filter(fieldDefinition -> this.state.getTypeFieldPermissionVerifier().isPermitted((GraphQLType)fieldsContainer, (GraphQLFieldDefinition)fieldDefinition)).collect(Collectors.toList());
    }

    private List<GraphQLType> redactTypeList(List<GraphQLType> fields) {
        return fields.stream().filter(type -> this.state.getTypeFieldPermissionVerifier().isPermitted((GraphQLType)type)).collect(Collectors.toList());
    }
}

