/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.graphql.authorization.enforcement;

import com.intuit.graphql.authorization.enforcement.AuthzInstrumentation;
import com.intuit.graphql.authorization.enforcement.AuthzListener;
import com.intuit.graphql.authorization.enforcement.TypeFieldPermissionVerifier;
import graphql.ErrorClassification;
import graphql.ErrorType;
import graphql.GraphQLError;
import graphql.GraphqlErrorBuilder;
import graphql.analysis.QueryVisitorFieldEnvironment;
import graphql.analysis.QueryVisitorStub;
import graphql.execution.ExecutionContext;
import graphql.language.Field;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.util.TraverserContext;
import graphql.util.TreeTransformerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedactingVisitor
extends QueryVisitorStub {
    private static final Logger log = LoggerFactory.getLogger(RedactingVisitor.class);
    private final AuthzInstrumentation.AuthzInstrumentationState instrumentationState;
    private final TypeFieldPermissionVerifier typeFieldPermissionVerifier;
    private final ExecutionContext executionContext;
    private final AuthzListener authzListener;

    public RedactingVisitor(AuthzInstrumentation.AuthzInstrumentationState state, ExecutionContext executionContext, AuthzListener authzListener) {
        this.instrumentationState = state;
        this.executionContext = executionContext;
        this.authzListener = authzListener;
        this.typeFieldPermissionVerifier = this.instrumentationState.getTypeFieldPermissionVerifier();
    }

    public void visitField(QueryVisitorFieldEnvironment queryVisitorFieldEnvironment) {
        GraphQLOutputType type = queryVisitorFieldEnvironment.getFieldDefinition().getType();
        GraphQLOutputType parentType = queryVisitorFieldEnvironment.getParentType();
        GraphQLFieldDefinition requestedFieldDefinition = queryVisitorFieldEnvironment.getFieldDefinition();
        Field field = queryVisitorFieldEnvironment.getField();
        boolean permitted = this.typeFieldPermissionVerifier.isPermitted((GraphQLType)requestedFieldDefinition.getType());
        if (permitted) {
            permitted = this.typeFieldPermissionVerifier.isPermitted((GraphQLType)parentType, requestedFieldDefinition);
        }
        if (!permitted) {
            String parentName = GraphQLTypeUtil.unwrapAll((GraphQLType)parentType).getName();
            this.authzListener.onFieldRedaction(this.executionContext, queryVisitorFieldEnvironment);
            GraphQLError error = GraphqlErrorBuilder.newError().errorType((ErrorClassification)ErrorType.DataFetchingException).message("403 - Not authorized to access field=%s of type=%s", new Object[]{field.getName(), parentName}).location(field.getSourceLocation()).build();
            this.instrumentationState.getAuthzErrors().add(error);
            TreeTransformerUtil.deleteNode((TraverserContext)queryVisitorFieldEnvironment.getTraverserContext());
        }
    }
}

