/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.graphql.authorization.enforcement;

import com.intuit.graphql.authorization.enforcement.PermissionVerifier;
import com.intuit.graphql.authorization.util.GraphQLUtil;
import graphql.introspection.Introspection;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import java.util.Map;
import java.util.Set;

public class TypeFieldPermissionVerifier
implements PermissionVerifier {
    private final Map<GraphQLType, Set<GraphQLFieldDefinition>> typeToFieldsMap;
    private final GraphQLSchema schema;

    TypeFieldPermissionVerifier(GraphQLSchema schema, Map<GraphQLType, Set<GraphQLFieldDefinition>> typeToFieldsMap) {
        this.typeToFieldsMap = typeToFieldsMap;
        this.schema = schema;
    }

    @Override
    public boolean isPermitted(GraphQLType graphQLType) {
        if (GraphQLTypeUtil.isInput((GraphQLType)graphQLType)) {
            return true;
        }
        if (GraphQLUtil.isOperationType(graphQLType, this.schema)) {
            return true;
        }
        if (GraphQLUtil.isReservedSchemaType(graphQLType)) {
            return true;
        }
        return this.typeToFieldsMap.containsKey(graphQLType);
    }

    @Override
    public boolean isPermitted(GraphQLType graphQLType, GraphQLFieldDefinition fieldDefinition) {
        if (GraphQLUtil.isReservedSchemaType(graphQLType)) {
            return true;
        }
        if (GraphQLTypeUtil.isInput((GraphQLType)graphQLType)) {
            return true;
        }
        if (graphQLType == this.schema.getQueryType() && GraphQLTypeUtil.unwrapAll((GraphQLType)fieldDefinition.getType()) == Introspection.__Schema) {
            return true;
        }
        Set<GraphQLFieldDefinition> fields = this.typeToFieldsMap.get(graphQLType);
        return fields != null && fields.contains(fieldDefinition);
    }
}

