/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.graphql.authorization.rules;

import com.intuit.graphql.authorization.config.AuthzClient;
import com.intuit.graphql.authorization.rules.RuleParser;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLType;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationHolderFactory {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationHolderFactory.class);
    private final Set<RuleParser> ruleParsers;

    public AuthorizationHolderFactory(Set<RuleParser> ruleParsers) {
        this.ruleParsers = Objects.requireNonNull(ruleParsers);
    }

    public Map<String, Map<GraphQLType, Set<GraphQLFieldDefinition>>> parse(Map<AuthzClient, List<String>> graphqlRulesByClient) {
        HashMap scopeToTypeMap = new HashMap();
        for (Map.Entry<AuthzClient, List<String>> entry : graphqlRulesByClient.entrySet()) {
            AuthzClient authzClient = entry.getKey();
            List<String> queries = entry.getValue();
            String id = authzClient.getId();
            HashMap intermediateResults = new HashMap();
            RuleParser ruleParser = this.ruleParsers.stream().filter(potentialRuleParser -> potentialRuleParser.isRuleTypeSupported(authzClient.getType())).findFirst().orElse(null);
            if (ruleParser == null) continue;
            for (String query : queries) {
                try {
                    Map<GraphQLType, Set<GraphQLFieldDefinition>> ruleSetMap = ruleParser.parseRule(query);
                    ruleSetMap.forEach((type, fields) -> intermediateResults.merge(type, fields, (oldSet, newSet) -> {
                        oldSet.addAll(newSet);
                        return oldSet;
                    }));
                }
                catch (Exception e) {
                    log.error("Failed to parse rule for scope " + id, (Throwable)e);
                }
            }
            if (intermediateResults.isEmpty()) continue;
            scopeToTypeMap.put(id, intermediateResults);
        }
        log.info("Parsed rules for scopes " + scopeToTypeMap.keySet());
        return Collections.unmodifiableMap(scopeToTypeMap);
    }
}

