/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.graphql.authorization.rules;

import com.intuit.graphql.authorization.config.AuthzClient;
import com.intuit.graphql.authorization.config.RuleType;
import com.intuit.graphql.authorization.rules.RuleParser;
import graphql.analysis.QueryTraverser;
import graphql.analysis.QueryVisitor;
import graphql.analysis.QueryVisitorFieldEnvironment;
import graphql.analysis.QueryVisitorStub;
import graphql.language.Document;
import graphql.parser.Parser;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryRuleParser
implements RuleParser {
    private static final Logger log = LoggerFactory.getLogger(QueryRuleParser.class);
    private final GraphQLSchema schema;

    public QueryRuleParser(GraphQLSchema schema) {
        this.schema = Objects.requireNonNull(schema);
    }

    private Map<GraphQLType, Set<GraphQLFieldDefinition>> getTypesAndFieldsMap(String query) {
        Document document = new Parser().parseDocument(query);
        final HashMap<GraphQLType, Set<GraphQLFieldDefinition>> typeToFieldMap = new HashMap<GraphQLType, Set<GraphQLFieldDefinition>>();
        QueryTraverser queryTraverser = QueryTraverser.newQueryTraverser().schema(this.schema).document(document).variables(new HashMap()).build();
        queryTraverser.visitPreOrder((QueryVisitor)new QueryVisitorStub(){

            public void visitField(QueryVisitorFieldEnvironment env) {
                GraphQLOutputType type = env.getParentType();
                GraphQLFieldDefinition fieldDefinition = env.getFieldDefinition();
                Set fields = typeToFieldMap.computeIfAbsent(type, k -> new HashSet());
                fields.add(fieldDefinition);
            }
        });
        return typeToFieldMap;
    }

    @Override
    public Map<GraphQLType, Set<GraphQLFieldDefinition>> parseRules(List<String> queries) {
        try {
            return queries.stream().flatMap(query -> this.parseRule((String)query).entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldSet, newSet) -> Collections.unmodifiableSet(Stream.concat(oldSet.stream(), newSet.stream()).collect(Collectors.toSet()))));
        }
        catch (Exception e) {
            log.error("Failed to parse rule " + queries, (Throwable)e);
            throw e;
        }
    }

    @Override
    public Map<GraphQLType, Set<GraphQLFieldDefinition>> parseRule(String query) {
        return this.getTypesAndFieldsMap(query);
    }

    @Override
    public boolean isRuleTypeSupported(RuleType type) {
        return type.equals(AuthzClient.ClientAuthorizationType.OFFLINE) || type.equals(AuthzClient.ClientAuthorizationType.ONLINE);
    }
}

