/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.graphql.authorization.util;

import graphql.Assert;
import graphql.introspection.Introspection;
import graphql.language.Document;
import graphql.language.OperationDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnmodifiedType;

public class GraphQLUtil {
    private GraphQLUtil() {
    }

    public static GraphQLObjectType getRootTypeFromOperation(OperationDefinition operationDefinition, GraphQLSchema schema) {
        switch (operationDefinition.getOperation()) {
            case MUTATION: {
                return (GraphQLObjectType)Assert.assertNotNull((Object)schema.getMutationType());
            }
            case QUERY: {
                return (GraphQLObjectType)Assert.assertNotNull((Object)schema.getQueryType());
            }
            case SUBSCRIPTION: {
                return (GraphQLObjectType)Assert.assertNotNull((Object)schema.getSubscriptionType());
            }
        }
        return (GraphQLObjectType)Assert.assertShouldNeverHappen();
    }

    public static OperationDefinition getOperationFromDocument(Document document) {
        return (OperationDefinition)document.getDefinitions().get(0);
    }

    public static boolean isOperationType(GraphQLType type, GraphQLSchema schema) {
        return type == schema.getQueryType() || type == schema.getMutationType() || type == schema.getSubscriptionType();
    }

    public static boolean isReservedSchemaType(GraphQLType type) {
        GraphQLUnmodifiedType unwrapped = GraphQLTypeUtil.unwrapAll((GraphQLType)type);
        return unwrapped.getName().startsWith("__");
    }

    public static boolean isIntrospection__Type(GraphQLType type) {
        GraphQLUnmodifiedType unwrappedType = GraphQLTypeUtil.unwrapAll((GraphQLType)type);
        return unwrappedType == Introspection.__Type;
    }

    public static boolean isListOfIntrospection__Type(GraphQLType type) {
        if (GraphQLTypeUtil.isNonNull((GraphQLType)type)) {
            return GraphQLUtil.isListOfIntrospection__Type(GraphQLTypeUtil.unwrapOne((GraphQLType)type));
        }
        if (GraphQLTypeUtil.isList((GraphQLType)type)) {
            return GraphQLUtil.isIntrospection__Type(type);
        }
        return false;
    }
}

