/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http.apache;

import com.intuit.karate.ScriptValue;
import com.intuit.karate.http.Cookie;
import com.intuit.karate.http.HttpClient;
import com.intuit.karate.http.HttpConfig;
import com.intuit.karate.http.HttpResponse;
import com.intuit.karate.http.HttpUtils;
import com.intuit.karate.http.MultiPartItem;
import com.intuit.karate.http.MultiValuedMap;
import com.intuit.karate.http.apache.RequestLoggingInterceptor;
import com.intuit.karate.http.apache.ResponseLoggingInterceptor;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.LenientSslConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.FormBodyPartBuilder;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class ApacheHttpClient
extends HttpClient<HttpEntity> {
    public static final String URI_CONTEXT_KEY = ApacheHttpClient.class.getName() + ".URI";
    private HttpClientBuilder clientBuilder;
    private URIBuilder uriBuilder;
    private RequestBuilder requestBuilder;
    private CookieStore cookieStore;
    private static final AtomicInteger BOUNDARY_COUNTER = new AtomicInteger();

    private void build() {
        try {
            URI uri = this.uriBuilder.build();
            String method = this.request.getMethod();
            this.requestBuilder = RequestBuilder.create((String)method).setUri(uri);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void configure(HttpConfig config) {
        this.clientBuilder = HttpClientBuilder.create();
        this.cookieStore = new BasicCookieStore();
        this.clientBuilder.setDefaultCookieStore(this.cookieStore);
        AtomicInteger counter = new AtomicInteger();
        this.clientBuilder.addInterceptorLast((HttpRequestInterceptor)new RequestLoggingInterceptor(counter));
        this.clientBuilder.addInterceptorLast((HttpResponseInterceptor)new ResponseLoggingInterceptor(counter));
        if (config.isSslEnabled()) {
            String sslAlgorithm = config.getSslAlgorithm();
            logger.info("ssl enabled, initializing generic trusted certificate / key-store with algorithm: {}", (Object)sslAlgorithm);
            SSLContext sslContext = HttpUtils.getSslContext((String)sslAlgorithm);
            LenientSslConnectionSocketFactory socketFactory = new LenientSslConnectionSocketFactory(sslContext, (HostnameVerifier)new NoopHostnameVerifier());
            this.clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory);
        }
        RequestConfig.Builder configBuilder = RequestConfig.custom().setConnectTimeout(config.getConnectTimeout()).setSocketTimeout(config.getReadTimeout());
        this.clientBuilder.setDefaultRequestConfig(configBuilder.build());
        if (config.getProxyUri() != null) {
            try {
                URI proxyUri = new URIBuilder(config.getProxyUri()).build();
                this.clientBuilder.setProxy(new HttpHost(proxyUri.getHost(), proxyUri.getPort(), proxyUri.getScheme()));
                if (config.getProxyUsername() != null && config.getProxyPassword() != null) {
                    BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                    credsProvider.setCredentials(new AuthScope(proxyUri.getHost(), proxyUri.getPort()), (Credentials)new UsernamePasswordCredentials(config.getProxyUsername(), config.getProxyPassword()));
                    this.clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void buildUrl(String url) {
        try {
            this.uriBuilder = new URIBuilder(url);
            this.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void buildPath(String path) {
        String temp = this.uriBuilder.getPath();
        if (!temp.endsWith("/")) {
            temp = temp + "/";
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        this.uriBuilder.setPath(temp + path);
        this.build();
    }

    protected void buildParam(String name, Object ... values) {
        for (Object o : values) {
            this.uriBuilder.setParameter(name, o == null ? "" : o.toString());
        }
        this.build();
    }

    protected void buildHeader(String name, Object value, boolean replace) {
        if (replace) {
            this.requestBuilder.removeHeaders(name);
        }
        this.requestBuilder.addHeader(name, value == null ? null : value.toString());
    }

    protected void buildCookie(Cookie c) {
        BasicClientCookie cookie = new BasicClientCookie(c.getName(), c.getValue());
        for (Map.Entry entry : c.entrySet()) {
            switch ((String)entry.getKey()) {
                case "domain": {
                    cookie.setDomain((String)entry.getValue());
                    break;
                }
                case "path": {
                    cookie.setPath((String)entry.getValue());
                }
            }
        }
        if (cookie.getDomain() == null) {
            cookie.setDomain(this.uriBuilder.getHost());
        }
        this.cookieStore.addCookie((org.apache.http.cookie.Cookie)cookie);
    }

    protected HttpEntity getEntity(List<MultiPartItem> items, String mediaType) {
        boolean hasNullName = false;
        for (MultiPartItem item : items) {
            if (item.getName() != null) continue;
            hasNullName = true;
            break;
        }
        if (hasNullName) {
            String boundary = ApacheHttpClient.createBoundary();
            String text = ApacheHttpClient.getAsStringEntity(items, boundary);
            ContentType ct = ContentType.create((String)mediaType).withParameters(new NameValuePair[]{new BasicNameValuePair("boundary", boundary)});
            return new StringEntity(text, ct);
        }
        MultipartEntityBuilder builder = MultipartEntityBuilder.create().setContentType(ContentType.create((String)mediaType));
        for (MultiPartItem item : items) {
            StringBody contentBody;
            if (item.getValue() == null || item.getValue().isNull()) {
                logger.warn("ignoring null multipart value for key: {}", (Object)item.getName());
                continue;
            }
            String name = item.getName();
            ScriptValue sv = item.getValue();
            if (name == null) continue;
            FormBodyPartBuilder formBuilder = FormBodyPartBuilder.create().setName(name);
            switch (sv.getType()) {
                case INPUT_STREAM: {
                    InputStream is = (InputStream)sv.getValue();
                    contentBody = new InputStreamBody(is, ContentType.APPLICATION_OCTET_STREAM, name);
                    break;
                }
                case XML: {
                    contentBody = new StringBody(sv.getAsString(), ContentType.APPLICATION_XML);
                    break;
                }
                case JSON: {
                    contentBody = new StringBody(sv.getAsString(), ContentType.APPLICATION_JSON);
                    break;
                }
                default: {
                    contentBody = new StringBody(sv.getAsString(), ContentType.TEXT_PLAIN);
                }
            }
            formBuilder = formBuilder.setBody((ContentBody)contentBody);
            builder = builder.addPart(formBuilder.build());
        }
        return builder.build();
    }

    protected HttpEntity getEntity(MultiValuedMap fields, String mediaType) {
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>(fields.size());
        for (Map.Entry entry : fields.entrySet()) {
            Object value;
            List values = (List)entry.getValue();
            Object stringValue = values == null ? null : (values.size() == 1 ? ((value = values.get(0)) == null ? null : (value instanceof String ? (String)value : value.toString())) : StringUtils.join((Iterable)values, (char)','));
            list.add(new BasicNameValuePair((String)entry.getKey(), (String)stringValue));
        }
        try {
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(list);
            entity.setContentType(mediaType);
            return entity;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected HttpEntity getEntity(String value, String mediaType) {
        return new StringEntity(value, ContentType.create((String)mediaType));
    }

    protected HttpEntity getEntity(InputStream value, String mediaType) {
        return new InputStreamEntity(value, ContentType.create((String)mediaType));
    }

    protected HttpResponse makeHttpRequest(HttpEntity entity, long startTime) {
        byte[] bytes;
        CloseableHttpResponse httpResponse;
        if (entity != null) {
            this.requestBuilder.setEntity(entity);
            this.requestBuilder.setHeader(entity.getContentType());
        }
        HttpUriRequest httpRequest = this.requestBuilder.build();
        CloseableHttpClient client = this.clientBuilder.build();
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute(URI_CONTEXT_KEY, (Object)this.getRequestUri());
        try {
            httpResponse = client.execute(httpRequest, (HttpContext)context);
            HttpEntity responseEntity = httpResponse.getEntity();
            InputStream is = responseEntity.getContent();
            bytes = IOUtils.toByteArray((InputStream)is);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        long responseTime = ApacheHttpClient.getResponseTime((long)startTime);
        HttpResponse response = new HttpResponse();
        response.setTime(responseTime);
        response.setUri(this.getRequestUri());
        response.setBody(bytes);
        response.setStatus(httpResponse.getStatusLine().getStatusCode());
        for (org.apache.http.cookie.Cookie c : this.cookieStore.getCookies()) {
            Cookie cookie = new Cookie(c.getName(), c.getValue());
            cookie.put((Object)"domain", (Object)c.getDomain());
            cookie.put((Object)"path", (Object)c.getPath());
            if (c.getExpiryDate() != null) {
                cookie.put((Object)"expires", (Object)(c.getExpiryDate().getTime() + ""));
            }
            cookie.put((Object)"persistent", (Object)(c.isPersistent() + ""));
            cookie.put((Object)"secure", (Object)(c.isSecure() + ""));
            response.addCookie(cookie);
        }
        for (Header header : httpResponse.getAllHeaders()) {
            response.addHeader(header.getName(), header.getValue());
        }
        return response;
    }

    protected String getRequestUri() {
        return this.requestBuilder.getUri().toString();
    }

    public static String createBoundary() {
        StringBuilder sb = new StringBuilder("boundary_");
        sb.append(BOUNDARY_COUNTER.incrementAndGet()).append('_');
        sb.append(System.currentTimeMillis());
        return sb.toString();
    }

    private static String getContentType(ScriptValue sv) {
        switch (sv.getType()) {
            case JSON: {
                return "application/json";
            }
            case XML: {
                return "application/xml";
            }
            case INPUT_STREAM: {
                return "application/octet-stream";
            }
        }
        return "text/plain";
    }

    private static String getAsStringEntity(List<MultiPartItem> items, String boundary) {
        StringBuilder sb = new StringBuilder();
        boolean firstItem = true;
        for (MultiPartItem item : items) {
            if (firstItem) {
                firstItem = false;
                sb.append("--");
            } else {
                sb.append("\r\n--");
            }
            sb.append(boundary);
            sb.append("\r\n");
            ScriptValue sv = item.getValue();
            String contentType = ApacheHttpClient.getContentType(sv);
            sb.append("Content-Type: ").append(contentType);
            sb.append("\r\n");
            String name = item.getName();
            if (name != null) {
                sb.append("Content-Disposition: form-data");
                if (sv.getType() == ScriptValue.Type.INPUT_STREAM) {
                    sb.append("; filename=\"").append(name).append("\"");
                }
                sb.append("; name=\"").append(name).append("\"");
                sb.append("\r\n");
            }
            sb.append("\r\n");
            if (sv.getType() == ScriptValue.Type.INPUT_STREAM) {
                InputStream is = (InputStream)sv.getValue(InputStream.class);
                try {
                    byte[] bytes = IOUtils.toByteArray((InputStream)is);
                    sb.append(new String(bytes, "utf-8"));
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            sb.append(sv.getAsString());
        }
        sb.append("\r\n--");
        sb.append(boundary);
        sb.append("--\r\n");
        return sb.toString();
    }
}

