/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http.apache;

import com.intuit.karate.http.HttpUtils;
import java.util.Collection;
import java.util.TreeSet;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;

public class LoggingUtils {
    private LoggingUtils() {
    }

    private static Collection<String> sortKeys(Header[] headers) {
        TreeSet<String> keys = new TreeSet<String>();
        for (Header header : headers) {
            keys.add(header.getName());
        }
        return keys;
    }

    private static void logHeaderLine(StringBuilder sb, int id, char prefix, String key, Header[] headers) {
        sb.append(id).append(' ').append(prefix).append(' ').append(key).append(": ");
        for (int i = 0; i < headers.length; ++i) {
            sb.append(headers[i].getValue());
            if (i >= headers.length - 1) continue;
            sb.append(',');
        }
        sb.append('\n');
    }

    public static void logHeaders(StringBuilder sb, int id, char prefix, HttpRequest request) {
        for (String key : LoggingUtils.sortKeys(request.getAllHeaders())) {
            Header[] headers = request.getHeaders(key);
            LoggingUtils.logHeaderLine(sb, id, prefix, key, headers);
        }
    }

    public static void logHeaders(StringBuilder sb, int id, char prefix, HttpResponse response) {
        for (String key : LoggingUtils.sortKeys(response.getAllHeaders())) {
            Header[] headers = response.getHeaders(key);
            LoggingUtils.logHeaderLine(sb, id, prefix, key, headers);
        }
    }

    public static boolean isPrintable(HttpEntity entity) {
        if (entity == null) {
            return false;
        }
        return entity.getContentType() != null && HttpUtils.isPrintable((String)entity.getContentType().getValue());
    }
}

