/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http.apache;

import com.intuit.karate.http.apache.ApacheHttpClient;
import com.intuit.karate.http.apache.LoggingEntityWrapper;
import com.intuit.karate.http.apache.LoggingUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestLoggingInterceptor
implements HttpRequestInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(RequestLoggingInterceptor.class);
    private final AtomicInteger counter;

    public RequestLoggingInterceptor(AtomicInteger counter) {
        this.counter = counter;
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        HttpEntityEnclosingRequest entityRequest;
        HttpEntity entity;
        int id = this.counter.incrementAndGet();
        String uri = (String)context.getAttribute(ApacheHttpClient.URI_CONTEXT_KEY);
        StringBuilder sb = new StringBuilder();
        sb.append('\n').append(id).append(" > ").append(request.getRequestLine().getMethod()).append(' ').append(uri).append('\n');
        LoggingUtils.logHeaders(sb, id, '>', request);
        if (request instanceof HttpEntityEnclosingRequest && LoggingUtils.isPrintable(entity = (entityRequest = (HttpEntityEnclosingRequest)request).getEntity())) {
            LoggingEntityWrapper wrapper = new LoggingEntityWrapper(entity);
            String buffer = IOUtils.toString((InputStream)wrapper.getContent(), (String)"utf-8");
            sb.append(buffer).append('\n');
            entityRequest.setEntity((HttpEntity)wrapper);
        }
        logger.debug(sb.toString());
    }
}

