/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http.apache;

import com.intuit.karate.http.apache.LoggingEntityWrapper;
import com.intuit.karate.http.apache.LoggingUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseLoggingInterceptor
implements HttpResponseInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(ResponseLoggingInterceptor.class);
    private final AtomicInteger counter;

    public ResponseLoggingInterceptor(AtomicInteger counter) {
        this.counter = counter;
    }

    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        int id = this.counter.get();
        StringBuilder sb = new StringBuilder();
        sb.append('\n').append(id).append(" < ").append(response.getStatusLine().getStatusCode()).append('\n');
        LoggingUtils.logHeaders(sb, id, '<', response);
        HttpEntity entity = response.getEntity();
        if (LoggingUtils.isPrintable(entity)) {
            LoggingEntityWrapper wrapper = new LoggingEntityWrapper(entity);
            String buffer = IOUtils.toString((InputStream)wrapper.getContent(), (String)"utf-8");
            sb.append(buffer).append('\n');
            response.setEntity((HttpEntity)wrapper);
        }
        logger.debug(sb.toString());
    }
}

