/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http.apache;

import com.intuit.karate.FileUtils;
import com.intuit.karate.ScenarioContext;
import com.intuit.karate.http.Cookie;
import com.intuit.karate.http.HttpClient;
import com.intuit.karate.http.HttpConfig;
import com.intuit.karate.http.HttpRequest;
import com.intuit.karate.http.HttpResponse;
import com.intuit.karate.http.HttpUtils;
import com.intuit.karate.http.MultiPartItem;
import com.intuit.karate.http.MultiValuedMap;
import com.intuit.karate.http.apache.ApacheHttpUtils;
import com.intuit.karate.http.apache.LenientCookieSpec;
import com.intuit.karate.http.apache.RequestLoggingInterceptor;
import com.intuit.karate.http.apache.ResponseLoggingInterceptor;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.LenientSslConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;

public class ApacheHttpClient
extends HttpClient<HttpEntity> {
    public static final String URI_CONTEXT_KEY = ApacheHttpClient.class.getName() + ".URI";
    private HttpClientBuilder clientBuilder;
    private URIBuilder uriBuilder;
    private RequestBuilder requestBuilder;
    private CookieStore cookieStore;
    private Charset charset;

    private void build() {
        try {
            URI uri = this.uriBuilder.build();
            String method = this.request.getMethod();
            this.requestBuilder = RequestBuilder.create((String)method).setUri(uri);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void configure(final HttpConfig config, final ScenarioContext context) {
        this.clientBuilder = HttpClientBuilder.create();
        this.charset = config.getCharset();
        if (!config.isFollowRedirects()) {
            this.clientBuilder.disableRedirectHandling();
        } else {
            this.clientBuilder.setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
        }
        this.clientBuilder.useSystemProperties();
        this.cookieStore = new BasicCookieStore();
        this.clientBuilder.setDefaultCookieStore(this.cookieStore);
        this.clientBuilder.setDefaultCookieSpecRegistry(LenientCookieSpec.registry());
        RequestLoggingInterceptor requestInterceptor = new RequestLoggingInterceptor(context);
        this.clientBuilder.addInterceptorLast((HttpRequestInterceptor)requestInterceptor);
        this.clientBuilder.addInterceptorLast((HttpResponseInterceptor)new ResponseLoggingInterceptor(requestInterceptor, context));
        if (config.isSslEnabled()) {
            SSLContext sslContext;
            String algorithm = config.getSslAlgorithm();
            KeyStore trustStore = HttpUtils.getKeyStore((ScenarioContext)context, (String)config.getSslTrustStore(), (String)config.getSslTrustStorePassword(), (String)config.getSslTrustStoreType());
            KeyStore keyStore = HttpUtils.getKeyStore((ScenarioContext)context, (String)config.getSslKeyStore(), (String)config.getSslKeyStorePassword(), (String)config.getSslKeyStoreType());
            try {
                SSLContextBuilder builder = SSLContexts.custom().setProtocol(algorithm);
                builder = trustStore == null && config.isSslTrustAll() ? builder.loadTrustMaterial((TrustStrategy)new TrustAllStrategy()) : (config.isSslTrustAll() ? builder.loadTrustMaterial(trustStore, (TrustStrategy)new TrustSelfSignedStrategy()) : builder.loadTrustMaterial(trustStore, null));
                if (keyStore != null) {
                    char[] keyPassword = config.getSslKeyStorePassword() == null ? null : config.getSslKeyStorePassword().toCharArray();
                    builder = builder.loadKeyMaterial(keyStore, keyPassword);
                }
                sslContext = builder.build();
            }
            catch (Exception e) {
                context.logger.error("ssl context init failed: {}", new Object[]{e.getMessage()});
                throw new RuntimeException(e);
            }
            LenientSslConnectionSocketFactory socketFactory = new LenientSslConnectionSocketFactory(sslContext, (HostnameVerifier)new NoopHostnameVerifier());
            this.clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory);
        }
        RequestConfig.Builder configBuilder = RequestConfig.custom().setCookieSpec(LenientCookieSpec.KARATE).setConnectTimeout(config.getConnectTimeout()).setSocketTimeout(config.getReadTimeout());
        this.clientBuilder.setDefaultRequestConfig(configBuilder.build());
        if (config.getProxyUri() != null) {
            try {
                final URI proxyUri = new URIBuilder(config.getProxyUri()).build();
                this.clientBuilder.setProxy(new HttpHost(proxyUri.getHost(), proxyUri.getPort(), proxyUri.getScheme()));
                if (config.getProxyUsername() != null && config.getProxyPassword() != null) {
                    BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                    credsProvider.setCredentials(new AuthScope(proxyUri.getHost(), proxyUri.getPort()), (Credentials)new UsernamePasswordCredentials(config.getProxyUsername(), config.getProxyPassword()));
                    this.clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
                }
                if (config.getNonProxyHosts() != null) {
                    ProxySelector proxySelector = new ProxySelector(){
                        private final List<String> proxyExceptions;
                        {
                            this.proxyExceptions = config.getNonProxyHosts();
                        }

                        @Override
                        public List<Proxy> select(URI uri) {
                            return Collections.singletonList(this.proxyExceptions.contains(uri.getHost()) ? Proxy.NO_PROXY : new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyUri.getHost(), proxyUri.getPort())));
                        }

                        @Override
                        public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
                            context.logger.info("connect failed to uri: {}", new Object[]{uri, ioe});
                        }
                    };
                    this.clientBuilder.setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(proxySelector));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void buildUrl(String url) {
        try {
            this.uriBuilder = new URIBuilder(url);
            this.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void buildPath(String path) {
        String temp = this.uriBuilder.getPath();
        if (!temp.endsWith("/")) {
            temp = temp + "/";
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        this.uriBuilder.setPath(temp + path);
        this.build();
    }

    protected void buildParam(String name, Object ... values) {
        if (values.length == 1) {
            Object v = values[0];
            if (v != null) {
                this.uriBuilder.setParameter(name, v.toString());
            }
        } else {
            Arrays.stream(values).filter(Objects::nonNull).forEach(o -> this.uriBuilder.addParameter(name, o.toString()));
        }
        this.build();
    }

    protected void buildHeader(String name, Object value, boolean replace) {
        if (replace) {
            this.requestBuilder.removeHeaders(name);
        }
        this.requestBuilder.addHeader(name, value == null ? null : value.toString());
    }

    protected void buildCookie(Cookie c) {
        BasicClientCookie cookie = new BasicClientCookie(c.getName(), c.getValue());
        for (Map.Entry entry : c.entrySet()) {
            switch ((String)entry.getKey()) {
                case "domain": {
                    cookie.setDomain((String)entry.getValue());
                    break;
                }
                case "path": {
                    cookie.setPath((String)entry.getValue());
                }
            }
        }
        if (cookie.getDomain() == null) {
            cookie.setDomain(this.uriBuilder.getHost());
        }
        this.cookieStore.addCookie((org.apache.http.cookie.Cookie)cookie);
    }

    protected HttpEntity getEntity(List<MultiPartItem> items, String mediaType) {
        return ApacheHttpUtils.getEntity(items, mediaType, this.charset);
    }

    protected HttpEntity getEntity(MultiValuedMap fields, String mediaType) {
        return ApacheHttpUtils.getEntity(fields, mediaType, this.charset);
    }

    protected HttpEntity getEntity(String value, String mediaType) {
        return ApacheHttpUtils.getEntity(value, mediaType, this.charset);
    }

    protected HttpEntity getEntity(InputStream value, String mediaType) {
        return ApacheHttpUtils.getEntity(value, mediaType, this.charset);
    }

    protected HttpResponse makeHttpRequest(HttpEntity entity, ScenarioContext context) {
        byte[] bytes;
        CloseableHttpResponse httpResponse;
        if (entity != null) {
            this.requestBuilder.setEntity(entity);
            this.requestBuilder.setHeader(entity.getContentType());
        }
        HttpUriRequest httpRequest = this.requestBuilder.build();
        CloseableHttpClient client = this.clientBuilder.build();
        BasicHttpContext httpContext = new BasicHttpContext();
        httpContext.setAttribute(URI_CONTEXT_KEY, (Object)this.getRequestUri());
        try {
            httpResponse = client.execute(httpRequest, (HttpContext)httpContext);
            HttpEntity responseEntity = httpResponse.getEntity();
            if (responseEntity == null || responseEntity.getContent() == null) {
                bytes = new byte[]{};
            } else {
                InputStream is = responseEntity.getContent();
                bytes = FileUtils.toBytes((InputStream)is);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HttpRequest actualRequest = context.getPrevRequest();
        HttpResponse response = new HttpResponse(actualRequest.getStartTime(), actualRequest.getEndTime());
        response.setUri(this.getRequestUri());
        response.setBody(bytes);
        response.setStatus(httpResponse.getStatusLine().getStatusCode());
        for (org.apache.http.cookie.Cookie c : this.cookieStore.getCookies()) {
            Cookie cookie = new Cookie(c.getName(), c.getValue());
            cookie.put((Object)"domain", (Object)c.getDomain());
            cookie.put((Object)"path", (Object)c.getPath());
            if (c.getExpiryDate() != null) {
                cookie.put((Object)"expires", (Object)(c.getExpiryDate().getTime() + ""));
            }
            cookie.put((Object)"persistent", (Object)(c.isPersistent() + ""));
            cookie.put((Object)"secure", (Object)(c.isSecure() + ""));
            response.addCookie(cookie);
        }
        this.cookieStore.clear();
        for (Header header : httpResponse.getAllHeaders()) {
            response.addHeader(header.getName(), header.getValue());
        }
        return response;
    }

    protected String getRequestUri() {
        return this.requestBuilder.getUri().toString();
    }
}

