/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http.apache;

import com.intuit.karate.ScriptValue;
import com.intuit.karate.StringUtils;
import com.intuit.karate.http.HttpBody;
import com.intuit.karate.http.HttpUtils;
import com.intuit.karate.http.MultiPartItem;
import com.intuit.karate.http.MultiValuedMap;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.FormBodyPartBuilder;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.message.BasicNameValuePair;

public class ApacheHttpUtils {
    private ApacheHttpUtils() {
    }

    public static HttpBody toBody(HttpEntity entity) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            entity.writeTo((OutputStream)baos);
            return HttpBody.bytes((byte[])baos.toByteArray(), (String)entity.getContentType().getValue());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static ContentType getContentType(String mediaType, Charset charset) {
        String cs;
        if (!HttpUtils.isPrintable((String)mediaType)) {
            try {
                return ContentType.create((String)mediaType);
            }
            catch (Exception e) {
                return null;
            }
        }
        Map map = HttpUtils.parseContentTypeParams((String)mediaType);
        if (map != null && (cs = (String)map.get("charset")) != null) {
            charset = Charset.forName(cs);
            map.remove("charset");
        }
        ContentType ct = ContentType.parse((String)mediaType).withCharset(charset);
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                ct = ct.withParameters(new NameValuePair[]{new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue())});
            }
        }
        return ct;
    }

    public static HttpEntity getEntity(InputStream is, String mediaType, Charset charset) {
        try {
            return new InputStreamEntity(is, (long)is.available(), ApacheHttpUtils.getContentType(mediaType, charset));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static HttpEntity getEntity(String value, String mediaType, Charset charset) {
        try {
            ContentType ct = ApacheHttpUtils.getContentType(mediaType, charset);
            if (ct == null) {
                StringEntity entity = new StringEntity(value);
                entity.setContentType(mediaType);
                return entity;
            }
            return new StringEntity(value, ct);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static HttpEntity getEntity(MultiValuedMap fields, String mediaType, Charset charset) {
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>(fields.size());
        for (Map.Entry entry : fields.entrySet()) {
            Object value;
            List values = (List)entry.getValue();
            Object stringValue = values == null ? null : (values.size() == 1 ? ((value = values.get(0)) == null ? null : (value instanceof String ? (String)value : value.toString())) : StringUtils.join((Collection)values, (char)','));
            list.add(new BasicNameValuePair((String)entry.getKey(), (String)stringValue));
        }
        try {
            Charset cs = HttpUtils.parseContentTypeCharset((String)mediaType);
            if (cs == null) {
                cs = charset;
            }
            String raw = URLEncodedUtils.format(list, (Charset)cs);
            int pos = mediaType.indexOf(59);
            if (pos != -1) {
                mediaType = mediaType.substring(0, pos);
            }
            return new StringEntity(raw, ContentType.create((String)mediaType, (Charset)cs));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static HttpEntity getEntity(List<MultiPartItem> items, String mediaType, Charset charset) {
        boolean hasNullName = false;
        for (MultiPartItem item : items) {
            if (item.getName() != null) continue;
            hasNullName = true;
            break;
        }
        if (hasNullName) {
            String boundary = HttpUtils.generateMimeBoundaryMarker();
            String text = HttpUtils.multiPartToString(items, (String)boundary);
            ContentType ct = ContentType.parse((String)mediaType).withParameters(new NameValuePair[]{new BasicNameValuePair("boundary", boundary)});
            return new StringEntity(text, ct);
        }
        MultipartEntityBuilder builder = MultipartEntityBuilder.create().setContentType(ContentType.parse((String)mediaType));
        for (MultiPartItem item : items) {
            Object contentBody;
            String name;
            if (item.getValue() == null || item.getValue().isNull() || (name = item.getName()) == null) continue;
            ScriptValue sv = item.getValue();
            String ct = item.getContentType();
            if (ct == null) {
                ct = HttpUtils.getContentType((ScriptValue)sv);
            }
            ContentType contentType = ContentType.create((String)ct);
            if (HttpUtils.isPrintable((String)ct)) {
                Charset cs = HttpUtils.parseContentTypeCharset((String)mediaType);
                if (cs == null) {
                    cs = charset;
                }
                contentType = contentType.withCharset(cs);
            }
            FormBodyPartBuilder formBuilder = FormBodyPartBuilder.create().setName(name);
            String filename = item.getFilename();
            if (filename != null) {
                InputStream is = sv.getAsStream();
                contentBody = new InputStreamBody(is, contentType, filename);
            } else {
                contentBody = sv.isStream() ? new InputStreamBody(sv.getAsStream(), contentType) : new StringBody(sv.getAsString(), contentType);
            }
            formBuilder = formBuilder.setBody((ContentBody)contentBody);
            builder = builder.addPart(formBuilder.build());
        }
        return builder.build();
    }
}

