/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http.apache;

import com.intuit.karate.FileUtils;
import com.intuit.karate.ScenarioContext;
import com.intuit.karate.http.HttpRequest;
import com.intuit.karate.http.apache.ApacheHttpClient;
import com.intuit.karate.http.apache.LoggingEntityWrapper;
import com.intuit.karate.http.apache.LoggingUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;

public class RequestLoggingInterceptor
implements HttpRequestInterceptor {
    private final ScenarioContext context;
    private final AtomicInteger counter = new AtomicInteger();
    private long startTime;

    public RequestLoggingInterceptor(ScenarioContext context) {
        this.context = context;
    }

    public AtomicInteger getCounter() {
        return this.counter;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void process(org.apache.http.HttpRequest request, HttpContext httpContext) throws HttpException, IOException {
        HttpEntityEnclosingRequest entityRequest;
        HttpEntity entity;
        HttpRequest actual = new HttpRequest();
        int id = this.counter.incrementAndGet();
        String uri = (String)httpContext.getAttribute(ApacheHttpClient.URI_CONTEXT_KEY);
        String method = request.getRequestLine().getMethod();
        actual.setUri(uri);
        actual.setMethod(method);
        StringBuilder sb = new StringBuilder();
        sb.append("request:\n").append(id).append(" > ").append(method).append(' ').append(uri).append('\n');
        LoggingUtils.logHeaders(sb, id, '>', request, actual);
        if (request instanceof HttpEntityEnclosingRequest && LoggingUtils.isPrintable(entity = (entityRequest = (HttpEntityEnclosingRequest)request).getEntity())) {
            LoggingEntityWrapper wrapper = new LoggingEntityWrapper(entity);
            String buffer = FileUtils.toString((InputStream)wrapper.getContent());
            if (this.context.getConfig().isLogPrettyRequest()) {
                buffer = FileUtils.toPrettyString((String)buffer);
            }
            sb.append(buffer).append('\n');
            actual.setBody(wrapper.getBytes());
            entityRequest.setEntity((HttpEntity)wrapper);
        }
        this.context.setPrevRequest(actual);
        this.context.logger.debug(sb.toString(), new Object[0]);
        this.startTime = System.currentTimeMillis();
        actual.setStartTime(this.startTime);
    }
}

