/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http.apache;

import com.intuit.karate.FileUtils;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.http.HttpRequest;
import com.intuit.karate.http.apache.LoggingEntityWrapper;
import com.intuit.karate.http.apache.LoggingUtils;
import com.intuit.karate.http.apache.RequestLoggingInterceptor;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;

public class ResponseLoggingInterceptor
implements HttpResponseInterceptor {
    private final ScenarioContext context;
    private final RequestLoggingInterceptor requestInterceptor;

    public ResponseLoggingInterceptor(RequestLoggingInterceptor requestInterceptor, ScenarioContext context) {
        this.requestInterceptor = requestInterceptor;
        this.context = context;
    }

    public void process(HttpResponse response, HttpContext httpContext) throws HttpException, IOException {
        HttpRequest actual = this.context.getPrevRequest();
        actual.stopTimer();
        int id = this.requestInterceptor.getCounter().get();
        StringBuilder sb = new StringBuilder();
        sb.append("response time in milliseconds: ").append(actual.getResponseTimeFormatted()).append('\n');
        sb.append(id).append(" < ").append(response.getStatusLine().getStatusCode()).append('\n');
        LoggingUtils.logHeaders(sb, id, '<', response);
        HttpEntity entity = response.getEntity();
        if (LoggingUtils.isPrintable(entity)) {
            LoggingEntityWrapper wrapper = new LoggingEntityWrapper(entity);
            String buffer = FileUtils.toString((InputStream)wrapper.getContent());
            if (this.context.getConfig().isLogPrettyResponse()) {
                buffer = FileUtils.toPrettyString((String)buffer);
            }
            sb.append(buffer).append('\n');
            response.setEntity((HttpEntity)wrapper);
        }
        this.context.logger.debug(sb.toString(), new Object[0]);
    }
}

