/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http.apache;

import com.intuit.karate.FileUtils;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.http.HttpLogModifier;
import com.intuit.karate.http.HttpRequest;
import com.intuit.karate.http.apache.ApacheHttpClient;
import com.intuit.karate.http.apache.LoggingEntityWrapper;
import com.intuit.karate.http.apache.LoggingUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;

public class RequestLoggingInterceptor
implements HttpRequestInterceptor {
    private final ScenarioContext context;
    private final HttpLogModifier logModifier;
    private final AtomicInteger counter = new AtomicInteger();

    public RequestLoggingInterceptor(ScenarioContext context) {
        this.context = context;
        this.logModifier = context.getConfig().getLogModifier();
    }

    public AtomicInteger getCounter() {
        return this.counter;
    }

    public void process(org.apache.http.HttpRequest request, HttpContext httpContext) throws HttpException, IOException {
        boolean showLog;
        HttpRequest actual = new HttpRequest();
        int id = this.counter.incrementAndGet();
        String uri = (String)httpContext.getAttribute(ApacheHttpClient.URI_CONTEXT_KEY);
        String method = request.getRequestLine().getMethod();
        actual.setUri(uri);
        actual.setMethod(method);
        this.context.setPrevRequest(actual);
        HttpLogModifier requestModifier = this.logModifier == null ? null : (this.logModifier.enableForUri(uri) ? this.logModifier : null);
        String maskedUri = requestModifier == null ? uri : requestModifier.uri(uri);
        boolean bl = showLog = !this.context.isReportDisabled() && this.context.getConfig().isShowLog();
        if (showLog) {
            HttpEntityEnclosingRequest entityRequest;
            HttpEntity entity;
            StringBuilder sb = new StringBuilder();
            sb.append("request:\n").append(id).append(" > ").append(method).append(' ').append(maskedUri).append('\n');
            LoggingUtils.logHeaders(requestModifier, sb, id, '>', request, actual);
            if (request instanceof HttpEntityEnclosingRequest && LoggingUtils.isPrintable(entity = (entityRequest = (HttpEntityEnclosingRequest)request).getEntity())) {
                LoggingEntityWrapper wrapper = new LoggingEntityWrapper(entity);
                String buffer = FileUtils.toString((InputStream)wrapper.getContent());
                if (this.context.getConfig().isLogPrettyRequest()) {
                    buffer = FileUtils.toPrettyString((String)buffer);
                }
                if (requestModifier != null) {
                    buffer = requestModifier.request(uri, buffer);
                }
                sb.append(buffer).append('\n');
                actual.setBody(wrapper.getBytes());
                entityRequest.setEntity((HttpEntity)wrapper);
            }
            this.context.logger.debug(sb.toString(), new Object[0]);
        }
        actual.startTimer();
    }
}

