/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.gatling;

import com.intuit.karate.FileUtils;
import com.intuit.karate.core.ExecutionContext;
import com.intuit.karate.core.ScenarioExecutionUnit;
import com.intuit.karate.job.ChunkResult;
import com.intuit.karate.job.JobConfig;
import com.intuit.karate.job.JobServer;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GatlingJobServer
extends JobServer {
    private final Set<String> executors = new HashSet<String>();
    private final Set<String> completed = new HashSet<String>();

    public GatlingJobServer(JobConfig config) {
        super(config, "target/gatling");
    }

    public void addFeature(ExecutionContext exec, List<ScenarioExecutionUnit> units, Runnable onComplete) {
    }

    public synchronized ChunkResult getNextChunk(String executorId) {
        if (this.executors.contains(executorId)) {
            if (this.completed.size() >= this.executors.size()) {
                this.stop();
            }
            return null;
        }
        this.executors.add(executorId);
        ChunkResult chunk = new ChunkResult(null, null);
        chunk.setChunkId(executorId);
        return chunk;
    }

    public synchronized void handleUpload(File upload, String executorId, String chunkId) {
        File[] dirs;
        String karateLog = upload.getPath() + File.separator + "karate.log";
        File karateLogFile = new File(karateLog);
        if (karateLogFile.exists()) {
            karateLogFile.renameTo(new File(karateLog + ".txt"));
        }
        String gatlingReportDir = "target" + File.separator + "reports" + File.separator;
        for (File dir : dirs = upload.listFiles()) {
            File file;
            if (!dir.isDirectory() || (file = GatlingJobServer.getFirstFileWithExtension((File)dir, (String)"log")) == null) continue;
            FileUtils.copy((File)file, (File)new File(gatlingReportDir + "simulation_" + chunkId + ".log"));
        }
        this.completed.add(executorId);
    }
}

