/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.gatling;

import com.intuit.karate.FileUtils;
import com.intuit.karate.StringUtils;
import com.intuit.karate.job.JobChunk;
import com.intuit.karate.job.JobCommand;
import com.intuit.karate.job.JobConfigBase;
import com.intuit.karate.job.JobUtils;
import io.gatling.app.Gatling;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GatlingMavenJobConfig
extends JobConfigBase<Integer> {
    private String mainCommand = "mvn gatling:test";
    private String buildDir = FileUtils.getBuildDir();
    private String reportDir = "karate-reports";
    private String executorDir = this.buildDir + File.separator + "gatling";

    public GatlingMavenJobConfig(int executorCount, String host, int port) {
        super(executorCount, host, port);
    }

    public List<Integer> getInitialChunks() {
        int count = this.getExecutorCount();
        if (count < 1) {
            throw new RuntimeException("executor count should be greater than zero");
        }
        ArrayList<Integer> list = new ArrayList<Integer>(count);
        for (int i = 0; i < count; ++i) {
            list.add(i);
        }
        return list;
    }

    public void setMainCommand(String mainCommand) {
        this.mainCommand = mainCommand;
    }

    public String getExecutorDir() {
        return this.executorDir;
    }

    public void setExecutorDir(String executorDir) {
        this.executorDir = executorDir;
    }

    public void setReportDir(String reportDir) {
        this.reportDir = reportDir;
    }

    public void setBuildDir(String buildDir) {
        this.buildDir = buildDir;
    }

    public List<JobCommand> getMainCommands(JobChunk jc) {
        String temp = this.mainCommand;
        for (String k : this.sysPropKeys) {
            String v = StringUtils.trimToEmpty((String)System.getProperty(k));
            if (v.isEmpty()) continue;
            temp = temp + " -D" + k + "=" + v;
        }
        return Collections.singletonList(new JobCommand(temp));
    }

    public Integer handleUpload(JobChunk<Integer> jc, File upload) {
        File[] dirs;
        String karateLog = upload.getPath() + File.separator + "karate.log";
        File karateLogFile = new File(karateLog);
        if (karateLogFile.exists()) {
            karateLogFile.renameTo(new File(karateLog + ".txt"));
        }
        String gatlingReportDir = this.buildDir + File.separator + this.reportDir;
        new File(gatlingReportDir).mkdirs();
        for (File dir : dirs = upload.listFiles()) {
            File file;
            if (!dir.isDirectory() || (file = JobUtils.getFirstFileMatching((File)dir, n -> n.endsWith("simulation.log"))) == null) continue;
            FileUtils.copy((File)file, (File)new File(gatlingReportDir + File.separator + "simulation_" + jc.getId() + ".log"));
        }
        return (Integer)jc.getValue();
    }

    public void onStop() {
        super.onStop();
        Gatling.main((String[])new String[]{"-ro", this.reportDir, "-rf", this.buildDir});
    }
}

