/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http.jersey;

import com.intuit.karate.http.HttpUtils;
import com.intuit.karate.http.LoggingFilterOutputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class LoggingInterceptor
implements ClientRequestFilter,
ClientResponseFilter,
WriterInterceptor {
    private final Logger logger;
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final AtomicInteger counter = new AtomicInteger();

    public LoggingInterceptor(Logger logger) {
        this.logger = logger;
    }

    private static boolean isPrintable(MediaType mediaType) {
        if (mediaType == null) {
            return false;
        }
        return HttpUtils.isPrintable((String)mediaType.toString());
    }

    private static void logHeaders(StringBuilder sb, int id, char prefix, MultivaluedMap<String, String> headers) {
        TreeSet keys = new TreeSet(headers.keySet());
        for (String key : keys) {
            List entries = (List)headers.get((Object)key);
            sb.append(id).append(' ').append(prefix).append(' ').append(key).append(": ").append(entries.size() == 1 ? entries.get(0) : entries).append('\n');
        }
    }

    public void filter(ClientRequestContext request) throws IOException {
        if (!this.logger.isDebugEnabled()) {
            return;
        }
        int id = this.counter.incrementAndGet();
        StringBuilder sb = new StringBuilder();
        sb.append('\n').append(id).append(" > ").append(request.getMethod()).append(' ').append(request.getUri().toASCIIString()).append('\n');
        LoggingInterceptor.logHeaders(sb, id, '>', (MultivaluedMap<String, String>)request.getStringHeaders());
        if (request.hasEntity() && LoggingInterceptor.isPrintable(request.getMediaType())) {
            LoggingFilterOutputStream out = new LoggingFilterOutputStream(request.getEntityStream(), sb);
            request.setEntityStream((OutputStream)out);
            request.setProperty(LoggingFilterOutputStream.KEY, (Object)out);
        } else {
            this.logger.debug(sb.toString());
        }
    }

    public void filter(ClientRequestContext request, ClientResponseContext response) throws IOException {
        if (!this.logger.isDebugEnabled()) {
            return;
        }
        int id = this.counter.get();
        StringBuilder sb = new StringBuilder();
        sb.append('\n').append(id).append(" < ").append(response.getStatus()).append('\n');
        LoggingInterceptor.logHeaders(sb, id, '<', (MultivaluedMap<String, String>)response.getHeaders());
        if (response.hasEntity() && LoggingInterceptor.isPrintable(response.getMediaType())) {
            InputStream is = response.getEntityStream();
            if (!is.markSupported()) {
                is = new BufferedInputStream(is);
            }
            is.mark(Integer.MAX_VALUE);
            String buffer = IOUtils.toString((InputStream)is, (Charset)UTF8);
            sb.append(buffer).append('\n');
            is.reset();
            response.setEntityStream(is);
        }
        this.logger.debug(sb.toString());
    }

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        LoggingFilterOutputStream out = (LoggingFilterOutputStream)context.getProperty(LoggingFilterOutputStream.KEY);
        context.proceed();
        if (out != null && this.logger.isDebugEnabled()) {
            StringBuilder sb = out.getBuffer();
            sb.append(new String(out.getBytes().toByteArray(), UTF8)).append('\n');
            this.logger.debug(sb.toString());
        }
    }
}

